/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials.provider;

import com.aliyun.credentials.Configuration;
import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.http.CompatibleUrlConnClient;
import com.aliyun.credentials.http.FormatType;
import com.aliyun.credentials.http.HttpRequest;
import com.aliyun.credentials.http.HttpResponse;
import com.aliyun.credentials.http.MethodType;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.RefreshResult;
import com.aliyun.credentials.provider.SessionCredentialsProvider;
import com.aliyun.credentials.utils.AuthUtils;
import com.aliyun.credentials.utils.ParameterHelper;
import com.aliyun.credentials.utils.StringUtils;
import com.google.gson.Gson;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class OIDCRoleArnCredentialProvider
extends SessionCredentialsProvider {
    public int durationSeconds = 3600;
    private String roleArn;
    private String oidcProviderArn;
    private volatile String oidcToken;
    private String oidcTokenFilePath;
    private String roleSessionName = "javaSdkRoleSessionName";
    private String regionId = "cn-hangzhou";
    private String policy;
    private int connectTimeout = 10000;
    private int readTimeout = 5000;
    private String STSEndpoint = "sts.aliyuncs.com";

    @Deprecated
    public OIDCRoleArnCredentialProvider(Configuration config) {
        this(config.getRoleArn(), config.getOIDCProviderArn(), config.getOIDCTokenFilePath());
        this.roleSessionName = config.getRoleSessionName();
        this.connectTimeout = config.getConnectTimeout();
        this.readTimeout = config.getReadTimeout();
        if (!StringUtils.isEmpty(config.getSTSEndpoint())) {
            this.STSEndpoint = config.getSTSEndpoint();
        }
    }

    @Deprecated
    public OIDCRoleArnCredentialProvider(Config config) {
        this(config.roleArn, config.oidcProviderArn, config.oidcTokenFilePath);
        this.roleSessionName = config.roleSessionName;
        this.connectTimeout = config.connectTimeout;
        this.readTimeout = config.timeout;
        this.policy = config.policy;
        this.durationSeconds = config.roleSessionExpiration;
        if (!StringUtils.isEmpty(config.STSEndpoint)) {
            this.STSEndpoint = config.STSEndpoint;
        }
    }

    @Deprecated
    public OIDCRoleArnCredentialProvider(String roleArn, String oidcProviderArn, String oidcTokenFilePath) {
        super(new BuilderImpl());
        if (!StringUtils.isEmpty(roleArn)) {
            this.roleArn = roleArn;
        } else if (!StringUtils.isEmpty(AuthUtils.getEnvironmentRoleArn())) {
            this.roleArn = AuthUtils.getEnvironmentRoleArn();
        } else {
            throw new CredentialException("roleArn does not exist and env ALIBABA_CLOUD_ROLE_ARN is null.");
        }
        if (!StringUtils.isEmpty(oidcProviderArn)) {
            this.oidcProviderArn = oidcProviderArn;
        } else if (!StringUtils.isEmpty(AuthUtils.getEnvironmentOIDCProviderArn())) {
            this.oidcProviderArn = AuthUtils.getEnvironmentOIDCProviderArn();
        } else {
            throw new CredentialException("OIDCProviderArn does not exist and env ALIBABA_CLOUD_OIDC_PROVIDER_ARN is null.");
        }
        if (!StringUtils.isEmpty(oidcTokenFilePath)) {
            this.oidcTokenFilePath = oidcTokenFilePath;
        } else if (!StringUtils.isEmpty(AuthUtils.getEnvironmentOIDCTokenFilePath())) {
            this.oidcTokenFilePath = AuthUtils.getEnvironmentOIDCTokenFilePath();
        } else {
            throw new CredentialException("OIDCTokenFilePath does not exist and env ALIBABA_CLOUD_OIDC_TOKEN_FILE is null.");
        }
        if (!StringUtils.isEmpty(AuthUtils.getEnvironmentRoleSessionName())) {
            this.roleSessionName = AuthUtils.getEnvironmentRoleSessionName();
        }
    }

    @Deprecated
    public OIDCRoleArnCredentialProvider(String accessKeyId, String accessKeySecret, String roleSessionName, String roleArn, String oidcProviderArn, String oidcTokenFilePath, String regionId, String policy) {
        this(roleSessionName, roleArn, oidcProviderArn, oidcTokenFilePath, regionId, policy);
    }

    @Deprecated
    public OIDCRoleArnCredentialProvider(String roleSessionName, String roleArn, String oidcProviderArn, String oidcTokenFilePath, String regionId, String policy) {
        this(roleArn, oidcProviderArn, oidcTokenFilePath);
        this.roleSessionName = roleSessionName;
        this.regionId = regionId;
        this.policy = policy;
    }

    private OIDCRoleArnCredentialProvider(BuilderImpl builder) {
        super(builder);
        this.roleSessionName = builder.roleSessionName == null ? (!StringUtils.isEmpty(AuthUtils.getEnvironmentRoleSessionName()) ? AuthUtils.getEnvironmentRoleSessionName() : "credentials-java-" + System.currentTimeMillis()) : builder.roleSessionName;
        int n = this.durationSeconds = builder.durationSeconds == null ? 3600 : builder.durationSeconds;
        if (this.durationSeconds < 900) {
            throw new IllegalArgumentException("Session duration should be in the range of 900s - max session duration.");
        }
        String string = this.roleArn = builder.roleArn == null ? AuthUtils.getEnvironmentRoleArn() : builder.roleArn;
        if (StringUtils.isEmpty(this.roleArn)) {
            throw new IllegalArgumentException("RoleArn or environment variable ALIBABA_CLOUD_ROLE_ARN cannot be empty.");
        }
        String string2 = this.oidcProviderArn = builder.oidcProviderArn == null ? AuthUtils.getEnvironmentOIDCProviderArn() : builder.oidcProviderArn;
        if (StringUtils.isEmpty(this.oidcProviderArn)) {
            throw new IllegalArgumentException("OIDCProviderArn or environment variable ALIBABA_CLOUD_OIDC_PROVIDER_ARN cannot be empty.");
        }
        String string3 = this.oidcTokenFilePath = builder.oidcTokenFilePath == null ? AuthUtils.getEnvironmentOIDCTokenFilePath() : builder.oidcTokenFilePath;
        if (StringUtils.isEmpty(this.oidcTokenFilePath)) {
            throw new IllegalArgumentException("OIDCTokenFilePath or environment variable ALIBABA_CLOUD_OIDC_TOKEN_FILE cannot be empty.");
        }
        this.regionId = builder.regionId;
        this.policy = builder.policy;
        this.connectTimeout = builder.connectionTimeout == null ? 5000 : builder.connectionTimeout;
        int n2 = this.readTimeout = builder.readTimeout == null ? 10000 : builder.readTimeout;
        if (!StringUtils.isEmpty(builder.STSEndpoint)) {
            this.STSEndpoint = builder.STSEndpoint;
        } else {
            String prefix;
            String string4 = builder.enableVpc != null ? (builder.enableVpc.booleanValue() ? "sts-vpc" : "sts") : (prefix = AuthUtils.isEnableVpcEndpoint() ? "sts-vpc" : "sts");
            this.STSEndpoint = !StringUtils.isEmpty(builder.stsRegionId) ? String.format("%s.%s.aliyuncs.com", prefix, builder.stsRegionId) : (!StringUtils.isEmpty(AuthUtils.getEnvironmentSTSRegion()) ? String.format("%s.%s.aliyuncs.com", prefix, AuthUtils.getEnvironmentSTSRegion()) : "sts.aliyuncs.com");
        }
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public RefreshResult<CredentialModel> refreshCredentials() {
        try (CompatibleUrlConnClient client = new CompatibleUrlConnClient();){
            RefreshResult<CredentialModel> refreshResult = this.createCredential(client);
            return refreshResult;
        }
    }

    public RefreshResult<CredentialModel> createCredential(CompatibleUrlConnClient client) {
        try {
            RefreshResult<CredentialModel> refreshResult = this.getNewSessionCredentials(client);
            return refreshResult;
        }
        catch (UnsupportedEncodingException e) {
            throw new CredentialException(e.getMessage(), e);
        }
        finally {
            client.close();
        }
    }

    public RefreshResult<CredentialModel> getNewSessionCredentials(CompatibleUrlConnClient client) throws UnsupportedEncodingException {
        HttpResponse httpResponse;
        String token;
        this.oidcToken = token = AuthUtils.getOIDCToken(this.oidcTokenFilePath);
        ParameterHelper parameterHelper = new ParameterHelper();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrlParameter("Action", "AssumeRoleWithOIDC");
        httpRequest.setUrlParameter("Format", "JSON");
        httpRequest.setUrlParameter("Version", "2015-04-01");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("DurationSeconds", String.valueOf(this.durationSeconds));
        body.put("RoleArn", this.roleArn);
        body.put("OIDCProviderArn", this.oidcProviderArn);
        body.put("OIDCToken", token);
        body.put("RoleSessionName", this.roleSessionName);
        if (this.policy != null) {
            body.put("Policy", this.policy);
        }
        StringBuilder content = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : body.entrySet()) {
            if (StringUtils.isEmpty((CharSequence)entry.getValue())) continue;
            if (first) {
                first = false;
            } else {
                content.append("&");
            }
            content.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
            content.append("=");
            content.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        httpRequest.setHttpContent(content.toString().getBytes("UTF-8"), "UTF-8", FormatType.FORM);
        httpRequest.setSysMethod(MethodType.POST);
        httpRequest.setSysConnectTimeout(this.connectTimeout);
        httpRequest.setSysReadTimeout(this.readTimeout);
        httpRequest.setSysUrl(parameterHelper.composeUrl(this.STSEndpoint, httpRequest.getUrlParameters(), "https"));
        try {
            httpResponse = client.syncInvoke(httpRequest);
        }
        catch (Exception e) {
            throw new CredentialException("Failed to connect OIDC Service: " + e);
        }
        if (httpResponse.getResponseCode() != 200) {
            throw new CredentialException(String.format("Error refreshing credentials from OIDC, HttpCode: %s, result: %s.", httpResponse.getResponseCode(), httpResponse.getHttpContentString()));
        }
        Gson gson = new Gson();
        Map map = gson.fromJson(httpResponse.getHttpContentString(), Map.class);
        if (null == map || !map.containsKey("Credentials")) {
            throw new CredentialException(String.format("Error retrieving credentials from OIDC result: %s.", httpResponse.getHttpContentString()));
        }
        Map result = (Map)map.get("Credentials");
        if (!(result.containsKey("AccessKeyId") && result.containsKey("AccessKeySecret") && result.containsKey("SecurityToken"))) {
            throw new CredentialException(String.format("Error retrieving credentials from OIDC result: %s.", httpResponse.getHttpContentString()));
        }
        long expiration = ParameterHelper.getUTCDate((String)result.get("Expiration")).getTime();
        CredentialModel credential = CredentialModel.builder().accessKeyId((String)result.get("AccessKeyId")).accessKeySecret((String)result.get("AccessKeySecret")).securityToken((String)result.get("SecurityToken")).type("oidc_role_arn").providerName(this.getProviderName()).expiration(expiration).build();
        return RefreshResult.builder(credential).staleTime(this.getStaleTime(expiration)).build();
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public void setDurationSeconds(int durationSeconds) {
        this.durationSeconds = durationSeconds;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getOIDCProviderArn() {
        return this.oidcProviderArn;
    }

    public String getOIDCToken() {
        return this.oidcToken;
    }

    public String getOIDCTokenFilePath() {
        return this.oidcTokenFilePath;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public void setRoleSessionName(String roleSessionName) {
        this.roleSessionName = roleSessionName;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getSTSEndpoint() {
        return this.STSEndpoint;
    }

    public void setSTSEndpoint(String STSEndpoint) {
        this.STSEndpoint = STSEndpoint;
    }

    @Override
    public String getProviderName() {
        return "oidc_role_arn";
    }

    @Override
    public void close() {
        super.close();
    }

    private static final class BuilderImpl
    extends SessionCredentialsProvider.BuilderImpl<OIDCRoleArnCredentialProvider, Builder>
    implements Builder {
        private String roleSessionName;
        private Integer durationSeconds;
        private String roleArn;
        private String oidcProviderArn;
        private String oidcTokenFilePath;
        private String regionId;
        private String policy;
        private Integer connectionTimeout;
        private Integer readTimeout;
        private String STSEndpoint;
        private String stsRegionId;
        private Boolean enableVpc;

        private BuilderImpl() {
        }

        @Override
        public Builder roleSessionName(String roleSessionName) {
            this.roleSessionName = roleSessionName;
            return this;
        }

        @Override
        public Builder durationSeconds(Integer durationSeconds) {
            this.durationSeconds = durationSeconds;
            return this;
        }

        @Override
        public Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder oidcProviderArn(String oidcProviderArn) {
            this.oidcProviderArn = oidcProviderArn;
            return this;
        }

        @Override
        public Builder oidcTokenFilePath(String oidcTokenFilePath) {
            this.oidcTokenFilePath = oidcTokenFilePath;
            return this;
        }

        @Override
        public Builder regionId(String regionId) {
            this.regionId = regionId;
            return this;
        }

        @Override
        public Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public Builder connectionTimeout(Integer connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        @Override
        public Builder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        @Override
        public Builder STSEndpoint(String STSEndpoint) {
            this.STSEndpoint = STSEndpoint;
            return this;
        }

        @Override
        public Builder stsRegionId(String stsRegionId) {
            this.stsRegionId = stsRegionId;
            return this;
        }

        @Override
        public Builder enableVpc(Boolean enableVpc) {
            this.enableVpc = enableVpc;
            return this;
        }

        @Override
        public OIDCRoleArnCredentialProvider build() {
            return new OIDCRoleArnCredentialProvider(this);
        }
    }

    public static interface Builder
    extends SessionCredentialsProvider.Builder<OIDCRoleArnCredentialProvider, Builder> {
        public Builder roleSessionName(String var1);

        public Builder durationSeconds(Integer var1);

        public Builder roleArn(String var1);

        public Builder oidcProviderArn(String var1);

        public Builder oidcTokenFilePath(String var1);

        public Builder regionId(String var1);

        public Builder policy(String var1);

        public Builder connectionTimeout(Integer var1);

        public Builder readTimeout(Integer var1);

        public Builder STSEndpoint(String var1);

        public Builder stsRegionId(String var1);

        public Builder enableVpc(Boolean var1);

        @Override
        public OIDCRoleArnCredentialProvider build();
    }
}

