import SlsTracker from "@aliyun-sls/web-track-browser";
import createStsPlugin from "@aliyun-sls/web-sts-plugin";

const opts = {
  host: process.env.YOUR_REGION_ID+".log.aliyuncs.com", // 所在地域的服务入口。例如cn-hangzhou.log.aliyuncs.com
  project: process.env.ALIYUN_LOG_PROJECT, // 从环境变量获取 Project 名称
  logstore: process.env.ALIYUN_LOG_LOGSTORE, // 从环境变量获取 Logstore 名称
  time: 10, // 发送日志的时间间隔，默认是10秒
  count: 10, // 发送日志的数量大小，默认是10条
  topic: "topic", // 自定义日志主题
  source: "source",
  tags: {
    tags: "tags",
  },
};

const stsOpt = {
  accessKeyId: "",
  accessKeySecret: "",
  securityToken: "",
  // 以下是一个 stsToken 刷新函数的简单示例
  refreshSTSToken: () =>
    new Promise((resolve, reject) => {
      const xhr = new window.XMLHttpRequest();
      xhr.open("GET", "http://"+process.env.YOUR_PUBLIC_IP+"/get_sts_token", true);
      xhr.send();
      xhr.onreadystatechange = () => {
        if (xhr.readyState === 4) {
          if (xhr.status === 200) {
            let credential = JSON.parse(xhr.response);
            // 函数的本质目的：设置 stsOpt 的临时密钥和令牌
            stsOpt.accessKeyId = credential.AccessKeyId;
            stsOpt.accessKeySecret = credential.AccessKeySecret;
            stsOpt.securityToken = credential.SecurityToken;
            resolve();
          } else {
            reject("Wrong status code.");
          }
        }
      };
    }),
  // refreshSTSTokenInterval: 300000,
  // stsTokenFreshTime: undefined,
};

const tracker = new SlsTracker(opts);
// 创建 sts 插件
const stsPlugin = createStsPlugin(stsOpt);
// 使用 sts 插件
tracker.useStsPlugin(stsPlugin);

// 用户登录跟踪
document.getElementById("loginButton").addEventListener("click", () => {
  const username = document.getElementById("username").value;
  tracker.send({
    eventType: "login",
    username: username,
  });
  console.log("Login event tracked for:", username);
});

// 商品浏览跟踪
document.querySelectorAll(".product").forEach((productButton) => {
  productButton.addEventListener("click", (event) => {
    const productName = event.target.getAttribute("data-product-name");
    const productPrice = event.target.getAttribute("data-price");
    tracker.send({
      eventType: "view_product",
      productName: productName,
      price: productPrice,
    });
    console.log("Product view tracked for:", productName);
  });
});

// 订单提交跟踪
document.getElementById("orderButton").addEventListener("click", () => {
  tracker.send({
    eventType: "place_order",
    orderDetails: "Order placed for example items",
  });
  console.log("Order placed event tracked");
});