/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.debezium.utils;

import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.chrono.IsoEra;

public class ConvertTimeBceUtil {
    private static final Date ONE_CE = Date.valueOf("0001-01-01");

    public static String resolveEra(boolean isBce, String value) {
        Object mangledValue = value;
        if (isBce) {
            if (((String)mangledValue).startsWith("-")) {
                mangledValue = ((String)mangledValue).substring(1);
            }
            if (!((String)mangledValue).endsWith(" BC")) {
                mangledValue = (String)mangledValue + " BC";
            }
        }
        return mangledValue;
    }

    public static boolean isBce(LocalDate date) {
        return date.getEra() == IsoEra.BCE;
    }

    public static String resolveEra(LocalDate date, String value) {
        return ConvertTimeBceUtil.resolveEra(ConvertTimeBceUtil.isBce(date), value);
    }

    public static String resolveEra(Date date, String value) {
        return ConvertTimeBceUtil.resolveEra(date.before(ONE_CE), value);
    }

    public static String resolveEra(Timestamp timestamp, String value) {
        return ConvertTimeBceUtil.resolveEra(timestamp.before(ONE_CE), value);
    }
}

