/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cdc.connectors.base.source.meta.split;

import io.debezium.relational.TableId;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.cdc.connectors.base.source.meta.offset.Offset;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetDeserializerSerializer;
import org.apache.flink.cdc.connectors.base.source.meta.offset.OffsetFactory;
import org.apache.flink.cdc.connectors.base.utils.SerializerUtils;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

public class FinishedSnapshotSplitInfo
implements OffsetDeserializerSerializer {
    private static final ThreadLocal<DataOutputSerializer> SERIALIZER_CACHE = ThreadLocal.withInitial(() -> new DataOutputSerializer(64));
    private final TableId tableId;
    private final String splitId;
    private final Object[] splitStart;
    private final Object[] splitEnd;
    private final Offset highWatermark;
    private final OffsetFactory offsetFactory;

    public FinishedSnapshotSplitInfo(TableId tableId, String splitId, Object[] splitStart, Object[] splitEnd, Offset highWatermark, OffsetFactory offsetFactory) {
        this.tableId = tableId;
        this.splitId = splitId;
        this.splitStart = splitStart;
        this.splitEnd = splitEnd;
        this.highWatermark = highWatermark;
        this.offsetFactory = (OffsetFactory)Preconditions.checkNotNull((Object)offsetFactory);
    }

    public TableId getTableId() {
        return this.tableId;
    }

    public String getSplitId() {
        return this.splitId;
    }

    public Object[] getSplitStart() {
        return this.splitStart;
    }

    public Object[] getSplitEnd() {
        return this.splitEnd;
    }

    public Offset getHighWatermark() {
        return this.highWatermark;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinishedSnapshotSplitInfo that = (FinishedSnapshotSplitInfo)o;
        return Objects.equals(this.tableId, that.tableId) && Objects.equals(this.splitId, that.splitId) && Arrays.equals(this.splitStart, that.splitStart) && Arrays.equals(this.splitEnd, that.splitEnd) && Objects.equals(this.highWatermark, that.highWatermark);
    }

    public int hashCode() {
        int result = Objects.hash(this.tableId, this.splitId, this.highWatermark);
        result = 31 * result + Arrays.hashCode(this.splitStart);
        result = 31 * result + Arrays.hashCode(this.splitEnd);
        return result;
    }

    public String toString() {
        return "FinishedSnapshotSplitInfo{tableId=" + this.tableId + ", splitId='" + this.splitId + "', splitStart=" + Arrays.toString(this.splitStart) + ", splitEnd=" + Arrays.toString(this.splitEnd) + ", highWatermark=" + this.highWatermark + "}";
    }

    public byte[] serialize() {
        try {
            DataOutputSerializer out = SERIALIZER_CACHE.get();
            byte[] result = this.serialize(out);
            out.clear();
            return result;
        }
        catch (IOException e) {
            throw new FlinkRuntimeException((Throwable)e);
        }
    }

    public byte[] serialize(DataOutputSerializer out) throws IOException {
        out.writeUTF(this.getTableId().toString());
        out.writeUTF(this.getSplitId());
        out.writeUTF(SerializerUtils.rowToSerializedString(this.getSplitStart()));
        out.writeUTF(SerializerUtils.rowToSerializedString(this.getSplitEnd()));
        out.writeUTF(SerializerUtils.rowToSerializedString(this.offsetFactory));
        this.writeOffsetPosition(this.getHighWatermark(), out);
        boolean useCatalogBeforeSchema = SerializerUtils.shouldUseCatalogBeforeSchema(this.getTableId());
        out.writeBoolean(useCatalogBeforeSchema);
        return out.getCopyOfBuffer();
    }

    @Override
    public OffsetFactory getOffsetFactory() {
        return this.offsetFactory;
    }
}

