/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.postgresql.replication.LogSequenceNumber;

public class Lsn
implements Comparable<Lsn> {
    public static final Lsn INVALID_LSN = new Lsn(0L);
    public static final Lsn NO_STOPPING_LSN = Lsn.valueOf("FFFFFFFF/FFFFFFFF");
    private final long value;

    private Lsn(long value) {
        this.value = value;
    }

    public static Lsn valueOf(Long value) {
        if (value == null) {
            return null;
        }
        if (value == 0L) {
            return INVALID_LSN;
        }
        return new Lsn(value);
    }

    public static Lsn valueOf(LogSequenceNumber value) {
        if (value.asLong() == 0L) {
            return INVALID_LSN;
        }
        return new Lsn(value.asLong());
    }

    public static Lsn valueOf(String strValue) {
        int slashIndex = strValue.lastIndexOf(47);
        if (slashIndex <= 0) {
            return INVALID_LSN;
        }
        String logicalXLogStr = strValue.substring(0, slashIndex);
        int logicalXlog = (int)Long.parseLong(logicalXLogStr, 16);
        String segmentStr = strValue.substring(slashIndex + 1, strValue.length());
        int segment = (int)Long.parseLong(segmentStr, 16);
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putInt(logicalXlog);
        buf.putInt(segment);
        ((Buffer)buf).position(0);
        long value = buf.getLong();
        return Lsn.valueOf(value);
    }

    public long asLong() {
        return this.value;
    }

    public LogSequenceNumber asLogSequenceNumber() {
        return LogSequenceNumber.valueOf(this.value);
    }

    public String asString() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(this.value);
        ((Buffer)buf).position(0);
        int logicalXlog = buf.getInt();
        int segment = buf.getInt();
        return String.format("%X/%X", logicalXlog, segment);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Lsn that = (Lsn)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean isValid() {
        return this != INVALID_LSN;
    }

    public boolean isNonStopping() {
        return this == NO_STOPPING_LSN;
    }

    public String toString() {
        return "LSN{" + this.asString() + "}";
    }

    @Override
    public int compareTo(Lsn o) {
        if (this.value == o.value) {
            return 0;
        }
        return this.value + Long.MIN_VALUE < o.value + Long.MIN_VALUE ? -1 : 1;
    }
}

