package com.aliyun.oss.web;
import com.aliyun.sts20150401.models.AssumeRoleResponse;
import com.aliyun.sts20150401.models.AssumeRoleResponseBody;
import com.aliyun.tea.TeaException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.codec.binary.Base64;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.util.*;

@Controller
public class WebController {

    // OSS basic information. Replace with actual bucket name, region-id, and host.
    String bucket = "examplebucket";
    String region = "cn-hangzhou";
    String host = "http://examplebucket.oss-cn-hangzhou.aliyuncs.com";
    // Set the upload callback URL (i.e., callback server address), which must be a public address. Used to handle communication between the application server and OSS. OSS will send file upload information to the application server via this callback URL after the file upload is complete.
    // Limit uploads to OSS with a specific file prefix.
    String upload_dir = "dir";

    // Specify the expiration time in seconds.
    Long expire_time = 3600L;

    /**
     * Generate an expiration time based on the specified duration in seconds.
     * @param seconds Duration in seconds.
     * @return ISO8601 formatted time string, e.g., "2014-12-01T12:00:00.000Z".
     */
    public static String generateExpiration(long seconds) {
        // Get the current timestamp in seconds
        long now = Instant.now().getEpochSecond();
        // Calculate the expiration time timestamp
        long expirationTime = now + seconds;
        // Convert the timestamp to an Instant object and format it as ISO8601
        Instant instant = Instant.ofEpochSecond(expirationTime);
        // Define the timezone as UTC
        ZoneId zone = ZoneOffset.UTC;
        // Convert Instant to ZonedDateTime
        ZonedDateTime zonedDateTime = instant.atZone(zone);
        // Define the date-time format, e.g., 2023-12-03T13:00:00.000Z
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        // Format the date-time
        String formattedDate = zonedDateTime.format(formatter);
        // Return the result
        return formattedDate;
    }
    // Initialize STS Client
    public static com.aliyun.sts20150401.Client createStsClient() throws Exception {
        // WARNING: Exposing this code may lead to exposure of AccessKey and threaten the security of all resources under the account. This code is for reference only.
        // It is recommended to use a more secure STS method.
        com.aliyun.teaopenapi.models.Config config = new com.aliyun.teaopenapi.models.Config()
                // Required. Ensure the environment variable OSS_ACCESS_KEY_ID is set in the running environment.
                .setAccessKeyId(System.getenv("OSS_ACCESS_KEY_ID"))
                // Required. Ensure the environment variable OSS_ACCESS_KEY_SECRET is set in the running environment.
                .setAccessKeySecret(System.getenv("OSS_ACCESS_KEY_SECRET"));
        // Endpoint reference: https://api.aliyun.com/product/Sts
        config.endpoint = "sts.cn-hangzhou.aliyuncs.com";
        return new com.aliyun.sts20150401.Client(config);
    }

    /**
     * Get STS temporary credentials
     * @return AssumeRoleResponseBodyCredentials object
     */
    public static AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials getCredential() throws Exception {
        com.aliyun.sts20150401.Client client = WebController.createStsClient();
        com.aliyun.sts20150401.models.AssumeRoleRequest assumeRoleRequest = new com.aliyun.sts20150401.models.AssumeRoleRequest()
                // Required. Ensure the environment variable OSS_STS_ROLE_ARN is set in the running environment.
                .setRoleArn(System.getenv("OSS_STS_ROLE_ARN"))
                .setRoleSessionName("yourRoleSessionName"); // Custom session name
        com.aliyun.teautil.models.RuntimeOptions runtime = new com.aliyun.teautil.models.RuntimeOptions();
        try {
            // Run the code and print the API return value yourself
            AssumeRoleResponse response = client.assumeRoleWithOptions(assumeRoleRequest, runtime);
            // The credentials include AccessKeyId, AccessKeySecret, and SecurityToken for subsequent use.
            return response.body.credentials;
        } catch (TeaException error) {
            // This is just a print display. Handle exceptions carefully in project code; do not ignore exceptions directly.
            // Error message
            System.out.println(error.getMessage());
            // Diagnostic address
            System.out.println(error.getData().get("Recommend"));
            com.aliyun.teautil.Common.assertAsString(error.message);
        } catch (Exception _error) {
            TeaException error = new TeaException(_error.getMessage(), _error);
            // This is just a print display. Handle exceptions carefully in project code; do not ignore exceptions directly.
            // Error message
            System.out.println(error.getMessage());
            // Diagnostic address
            System.out.println(error.getData().get("Recommend"));
            com.aliyun.teautil.Common.assertAsString(error.message);
        }
        // Return a default error response object to avoid returning null
        AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials defaultCredentials = new AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials();
        defaultCredentials.accessKeyId = "ERROR_ACCESS_KEY_ID";
        defaultCredentials.accessKeySecret = "ERROR_ACCESS_KEY_SECRET";
        defaultCredentials.securityToken = "ERROR_SECURITY_TOKEN";
        return defaultCredentials;
    }
    @GetMapping("/get_post_signature_for_oss_upload")
    public ResponseEntity<Map<String, String>> getPostSignatureForOssUpload() throws Exception {
        AssumeRoleResponseBody.AssumeRoleResponseBodyCredentials sts_data = getCredential();

        String accesskeyid =  sts_data.accessKeyId;
        String accesskeysecret =  sts_data.accessKeySecret;
        String securitytoken =  sts_data.securityToken;

        // Get the date in x-oss-credential, current date, format: yyyyMMdd
        ZonedDateTime today = ZonedDateTime.now().withZoneSameInstant(java.time.ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        String date = today.format(formatter);

        // Get x-oss-date
        ZonedDateTime now = ZonedDateTime.now().withZoneSameInstant(java.time.ZoneOffset.UTC);
        DateTimeFormatter formatter2 = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss'Z'");
        String x_oss_date = now.format(formatter2);

        // Step 1: Create policy.
        String x_oss_credential = accesskeyid + "/" + date + "/" + region + "/oss/aliyun_v4_request";

        ObjectMapper mapper = new ObjectMapper();

        Map<String, Object> policy = new HashMap<>();
        policy.put("expiration", generateExpiration(expire_time));

        List<Object> conditions = new ArrayList<>();

        Map<String, String> bucketCondition = new HashMap<>();
        bucketCondition.put("bucket", bucket);
        conditions.add(bucketCondition);

        Map<String, String> securityTokenCondition = new HashMap<>();
        securityTokenCondition.put("x-oss-security-token", securitytoken);
        conditions.add(securityTokenCondition);

        Map<String, String> signatureVersionCondition = new HashMap<>();
        signatureVersionCondition.put("x-oss-signature-version", "OSS4-HMAC-SHA256");
        conditions.add(signatureVersionCondition);

        Map<String, String> credentialCondition = new HashMap<>();
        credentialCondition.put("x-oss-credential", x_oss_credential); // Replace with actual access key id
        conditions.add(credentialCondition);

        Map<String, String> dateCondition = new HashMap<>();
        dateCondition.put("x-oss-date", x_oss_date);
        conditions.add(dateCondition);

        conditions.add(Arrays.asList("content-length-range", 1, 10240000));
        conditions.add(Arrays.asList("eq", "$success_action_status", "200"));
        conditions.add(Arrays.asList("starts-with", "$key", upload_dir));

        policy.put("conditions", conditions);

        String jsonPolicy = mapper.writeValueAsString(policy);

        // Step 2: Construct the string to sign (StringToSign).
        String stringToSign = new String(Base64.encodeBase64(jsonPolicy.getBytes()));
        // System.out.println("stringToSign: " + stringToSign);

        // Step 3: Calculate the SigningKey.
        byte[] dateKey = hmacsha256(("aliyun_v4" + accesskeysecret).getBytes(), date);
        byte[] dateRegionKey = hmacsha256(dateKey, region);
        byte[] dateRegionServiceKey = hmacsha256(dateRegionKey, "oss");
        byte[] signingKey = hmacsha256(dateRegionServiceKey, "aliyun_v4_request");
        // System.out.println("signingKey: " + BinaryUtil.toBase64String(signingKey));

        // Step 4: Calculate the Signature.
        byte[] result = hmacsha256(signingKey, stringToSign);
        String signature = BinaryUtil.toHex(result);
        // System.out.println("signature:" + signature);

        Map<String, String> response = new HashMap<>();
        // Add data to the map
        response.put("version", "OSS4-HMAC-SHA256");
        // This is an error-prone point. Do not directly pass policy; encode it with Base64 instead.
        response.put("policy", stringToSign);
        response.put("x_oss_credential", x_oss_credential);
        response.put("x_oss_date", x_oss_date);
        response.put("signature", signature);
        response.put("security_token", securitytoken);
        response.put("dir", upload_dir);
        response.put("host", host);
        // Return a ResponseEntity with status code 200 (OK) to the web end for PostObject operation
        return ResponseEntity.ok(response);
    }
    public static byte[] hmacsha256(byte[] key, String data) {
        try {
            // Initialize HMAC key specification, specifying the algorithm as HMAC-SHA256 and using the provided key.
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");

            // Get the Mac instance and specify the use of the HMAC-SHA256 algorithm via the getInstance method.
            Mac mac = Mac.getInstance("HmacSHA256");
            // Initialize the Mac object with the key.
            mac.init(secretKeySpec);

            // Perform HMAC calculation and return the result array via the doFinal method.
            byte[] hmacBytes = mac.doFinal(data.getBytes());

            return hmacBytes;
        } catch (Exception e) {
            throw new RuntimeException("Failed to calculate HMAC-SHA256", e);
        }
    }
}