/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.aliyun.tablestore;

import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnType;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyType;
import com.alicloud.openservices.tablestore.model.RecordColumn;
import com.alicloud.openservices.tablestore.model.StreamRecord;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class TableStoreSourceRDD$
implements Logging,
Serializable {
    public static final TableStoreSourceRDD$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new TableStoreSourceRDD$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Option<Object> extractValue(StreamRecord record, String fieldName, StructType schema2) {
        void var16_32;
        ColumnType columnType;
        None$ none$;
        boolean isPrimaryKey = record.getPrimaryKey().contains(fieldName);
        Map<String, RecordColumn> attributeColumnsMap = this.getAttributeColumnsMap(record);
        boolean isAttributeKey = attributeColumnsMap.keySet().contains((Object)fieldName);
        if (isPrimaryKey) {
            Some some;
            PrimaryKeyColumn pkColumn = record.getPrimaryKey().getPrimaryKeyColumn(fieldName);
            PrimaryKeyType primaryKeyType = pkColumn.getValue().getType();
            if (PrimaryKeyType.INTEGER.equals(primaryKeyType)) {
                Some some2;
                DataType dataType = schema2.apply(pkColumn.getName()).dataType();
                if (LongType$.MODULE$.equals(dataType)) {
                    some2 = new Some((Object)BoxesRunTime.boxToLong((long)pkColumn.getValue().asLong()));
                } else if (IntegerType$.MODULE$.equals(dataType)) {
                    some2 = new Some((Object)BoxesRunTime.boxToInteger((int)((int)pkColumn.getValue().asLong())));
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    some2 = new Some((Object)BoxesRunTime.boxToFloat((float)pkColumn.getValue().asLong()));
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    some2 = new Some((Object)BoxesRunTime.boxToDouble((double)pkColumn.getValue().asLong()));
                } else if (ShortType$.MODULE$.equals(dataType)) {
                    some2 = new Some((Object)BoxesRunTime.boxToShort((short)((short)pkColumn.getValue().asLong())));
                } else {
                    if (!ByteType$.MODULE$.equals(dataType)) {
                        throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"data type mismatch, expected: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema2.apply(pkColumn.getName()).dataType()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"real: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{pkColumn.getValue().getType()}))).toString());
                    }
                    some2 = new Some((Object)BoxesRunTime.boxToByte((byte)((byte)pkColumn.getValue().asLong())));
                }
                some = some2;
            } else if (PrimaryKeyType.STRING.equals(primaryKeyType)) {
                some = new Some((Object)pkColumn.getValue().asString());
            } else {
                if (!PrimaryKeyType.BINARY.equals(primaryKeyType)) {
                    void var7_7;
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unknown data type of primary key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var7_7.getValue().getType()})));
                }
                some = new Some((Object)pkColumn.getValue().asBinary());
            }
            none$ = some;
            return none$;
        }
        if (!isAttributeKey) {
            none$ = None$.MODULE$;
            return none$;
        }
        Column col = ((RecordColumn)attributeColumnsMap.apply((Object)fieldName)).getColumn();
        DataType schemaType = schema2.apply(col.getName()).dataType();
        if (!this.checkTypeMatched(schemaType, columnType = col.getValue().getType())) {
            void var14_14;
            void var13_13;
            void var12_12;
            this.logWarning((Function0<String>)new Serializable((Column)var12_12, (DataType)var13_13, (ColumnType)var14_14){
                public static final long serialVersionUID = 0L;
                private final Column col$1;
                private final DataType schemaType$1;
                private final ColumnType columnType$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"column [", "] data type mismatch, expected: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.col$1.getName(), this.schemaType$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"real: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnType$1}))).toString();
                }
                {
                    this.col$1 = col$1;
                    this.schemaType$1 = schemaType$1;
                    this.columnType$1 = columnType$1;
                }
            });
            return None$.MODULE$;
        }
        ColumnType columnType2 = columnType;
        if (ColumnType.INTEGER.equals(columnType2)) {
            void var20_25;
            long value = col.getValue().asLong();
            DataType dataType = schemaType;
            if (LongType$.MODULE$.equals(dataType)) {
                Some some = new Some((Object)BoxesRunTime.boxToLong((long)value));
            } else if (IntegerType$.MODULE$.equals(dataType)) {
                Some some = new Some((Object)BoxesRunTime.boxToInteger((int)((int)value)));
            } else if (FloatType$.MODULE$.equals(dataType)) {
                Some some = new Some((Object)BoxesRunTime.boxToFloat((float)value));
            } else if (DoubleType$.MODULE$.equals(dataType)) {
                Some some = new Some((Object)BoxesRunTime.boxToDouble((double)value));
            } else if (ShortType$.MODULE$.equals(dataType)) {
                Some some = new Some((Object)BoxesRunTime.boxToShort((short)((short)value)));
            } else if (ByteType$.MODULE$.equals(dataType)) {
                Some some = new Some((Object)BoxesRunTime.boxToByte((byte)((byte)value)));
            } else {
                None$ none$2 = None$.MODULE$;
            }
            void var16_26 = var20_25;
        } else if (ColumnType.DOUBLE.equals(columnType2)) {
            Some some = new Some((Object)BoxesRunTime.boxToDouble((double)col.getValue().asDouble()));
        } else if (ColumnType.STRING.equals(columnType2)) {
            Some some = new Some((Object)col.getValue().asString());
        } else if (ColumnType.BOOLEAN.equals(columnType2)) {
            Some some = new Some((Object)BoxesRunTime.boxToBoolean((boolean)col.getValue().asBoolean()));
        } else if (ColumnType.BINARY.equals(columnType2)) {
            Some some = new Some((Object)col.getValue().asBinary());
        } else {
            None$ none$3 = None$.MODULE$;
        }
        none$ = var16_32;
        return none$;
    }

    private boolean checkTypeMatched(DataType schemaType, ColumnType columnType) {
        boolean bl;
        ColumnType columnType2 = columnType;
        if (ColumnType.INTEGER.equals(columnType2)) {
            DataType dataType = schemaType;
            boolean bl2 = LongType$.MODULE$.equals(dataType) ? true : (IntegerType$.MODULE$.equals(dataType) ? true : (FloatType$.MODULE$.equals(dataType) ? true : (DoubleType$.MODULE$.equals(dataType) ? true : (ShortType$.MODULE$.equals(dataType) ? true : ByteType$.MODULE$.equals(dataType)))));
            boolean bl3 = bl2;
            bl = bl3;
        } else if (ColumnType.DOUBLE.equals(columnType2)) {
            DataType dataType = schemaType;
            boolean bl4 = DoubleType$.MODULE$.equals(dataType);
            bl = bl4;
        } else if (ColumnType.STRING.equals(columnType2)) {
            DataType dataType = schemaType;
            boolean bl5 = StringType$.MODULE$.equals(dataType);
            bl = bl5;
        } else if (ColumnType.BOOLEAN.equals(columnType2)) {
            DataType dataType = schemaType;
            boolean bl6 = BooleanType$.MODULE$.equals(dataType);
            bl = bl6;
        } else if (ColumnType.BINARY.equals(columnType2)) {
            DataType dataType = schemaType;
            boolean bl7 = BinaryType$.MODULE$.equals(dataType);
            bl = bl7;
        } else {
            bl = false;
        }
        return bl;
    }

    public Option<Object> extractColumnType(StreamRecord record, String fieldName) {
        Map<String, RecordColumn> attributeColumnsMap = this.getAttributeColumnsMap(record);
        return attributeColumnsMap.contains((Object)fieldName) ? new Some((Object)((RecordColumn)attributeColumnsMap.apply((Object)fieldName)).getColumnType().name()) : None$.MODULE$;
    }

    private Map<String, RecordColumn> getAttributeColumnsMap(StreamRecord record) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(record.getColumns()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, RecordColumn> apply(RecordColumn column) {
                return new Tuple2((Object)column.getColumn().getName(), (Object)column);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public long $lessinit$greater$default$10() {
        return -1L;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TableStoreSourceRDD$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

