/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.aliyun.tablestore;

import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.aliyun.tablestore.TableStoreSourceOffset;
import org.apache.spark.sql.aliyun.tablestore.TableStoreSourceOffset$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import org.apache.spark.sql.execution.streaming.SerializedOffset;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u001f\tiB+\u00192mKN#xN]3J]&$\u0018.\u00197PM\u001a\u001cX\r^,sSR,'O\u0003\u0002\u0004\t\u0005QA/\u00192mKN$xN]3\u000b\u0005\u00151\u0011AB1mSf,hN\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A\u0019\u0011C\u0006\r\u000e\u0003IQ!a\u0005\u000b\u0002\u0013M$(/Z1nS:<'BA\u000b\u0007\u0003%)\u00070Z2vi&|g.\u0003\u0002\u0018%\ty\u0001\n\u0012$T\u001b\u0016$\u0018\rZ1uC2{w\r\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\t1B+\u00192mKN#xN]3T_V\u00148-Z(gMN,G\u000f\u0003\u0005\u001e\u0001\t\u0005\t\u0015!\u0003\u001f\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o!\ty\u0002%D\u0001\u0007\u0013\t\tcA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u00031iW\r^1eCR\f\u0007+\u0019;i!\t)3F\u0004\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQs%\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y5\u0012aa\u0015;sS:<'B\u0001\u0016(\u0011\u0015y\u0003\u0001\"\u00011\u0003\u0019a\u0014N\\5u}Q\u0019\u0011GM\u001a\u0011\u0005e\u0001\u0001\"B\u000f/\u0001\u0004q\u0002\"B\u0012/\u0001\u0004!\u0003bB\u001b\u0001\u0005\u0004%\tAN\u0001\b-\u0016\u00136+S(O+\u00059\u0004C\u0001\u00149\u0013\tItEA\u0002J]RDaa\u000f\u0001!\u0002\u00139\u0014\u0001\u0003,F%NKuJ\u0014\u0011\t\u000bu\u0002A\u0011\t \u0002\u0013M,'/[1mSj,GcA C\tB\u0011a\u0005Q\u0005\u0003\u0003\u001e\u0012A!\u00168ji\")1\t\u0010a\u00011\u0005AQ.\u001a;bI\u0006$\u0018\rC\u0003Fy\u0001\u0007a)A\u0002pkR\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u0005%|'\"A&\u0002\t)\fg/Y\u0005\u0003\u001b\"\u0013AbT;uaV$8\u000b\u001e:fC6DQa\u0014\u0001\u0005BA\u000b1\u0002Z3tKJL\u0017\r\\5{KR\u0011\u0001$\u0015\u0005\u0006%:\u0003\raU\u0001\u0003S:\u0004\"a\u0012+\n\u0005UC%aC%oaV$8\u000b\u001e:fC6\u0004")
public class TableStoreInitialOffsetWriter
extends HDFSMetadataLog<TableStoreSourceOffset> {
    private final int VERSION;

    public int VERSION() {
        return this.VERSION;
    }

    public void serialize(TableStoreSourceOffset metadata, OutputStream out) {
        out.write(0);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v", "\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.VERSION())})));
        writer.write(metadata.json());
        writer.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TableStoreSourceOffset deserialize(InputStream in) {
        TableStoreSourceOffset tableStoreSourceOffset;
        in.read();
        String content = IOUtils.toString((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(content)).nonEmpty());
        if (StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(content), 0) == 'v') {
            int indexOfNewLine = content.indexOf("\n");
            if (indexOfNewLine <= 0) throw new IllegalStateException("Log file was malformed: failed to detect the log file version line.");
            this.parseVersion(content.substring(0, indexOfNewLine), this.VERSION());
            tableStoreSourceOffset = TableStoreSourceOffset$.MODULE$.apply(new SerializedOffset(content.substring(indexOfNewLine + 1)));
            return tableStoreSourceOffset;
        } else {
            tableStoreSourceOffset = TableStoreSourceOffset$.MODULE$.apply(new SerializedOffset(content));
        }
        return tableStoreSourceOffset;
    }

    public TableStoreInitialOffsetWriter(SparkSession sparkSession, String metadataPath) {
        super(sparkSession, metadataPath, ClassTag$.MODULE$.apply(TableStoreSourceOffset.class));
        this.VERSION = 2;
    }
}

