/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hive;

import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hive.TableMapReduceUtils;
import com.aliyun.openservices.tablestore.hive.TableStoreConsts;
import com.aliyun.openservices.tablestore.hive.TableStoreInputFormat;
import com.aliyun.openservices.tablestore.hive.TableStoreOutputFormat;
import com.aliyun.openservices.tablestore.hive.TableStoreSerDe;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreStorageHandler
extends DefaultStorageHandler {
    private static Logger logger = LoggerFactory.getLogger(TableStoreStorageHandler.class);

    public Class<? extends InputFormat> getInputFormatClass() {
        return TableStoreInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return TableStoreOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return TableStoreSerDe.class;
    }

    public void configureInputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties props = tableDesc.getProperties();
        logger.debug("TableDesc: {}", (Object)props);
        for (String key : TableStoreConsts.REQUIRES) {
            String val = TableStoreStorageHandler.copyToMap(jobProperties, props, key);
            if (val != null) continue;
            logger.error("missing required table properties: {}", (Object)key);
            throw new IllegalArgumentException("missing required table properties: " + key);
        }
        for (String key : TableStoreConsts.OPTIONALS) {
            TableStoreStorageHandler.copyToMap(jobProperties, props, key);
        }
    }

    private static String copyToMap(Map<String, String> to, Properties from, String key) {
        String val = from.getProperty(key);
        if (val != null) {
            to.put(key, val);
        }
        return val;
    }

    public void configureOutputJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        this.configureInputJobProperties(tableDesc, jobProperties);
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        throw new UnsupportedOperationException();
    }

    public void configureJobConf(TableDesc tableDesc, JobConf jobConf) {
        try {
            Properties from = tableDesc.getProperties();
            logger.debug("TableDesc: {}", (Object)from);
            logger.debug("job conf: {}", (Object)jobConf);
            jobConf.setJarByClass(TableStoreStorageHandler.class);
            String accessKeyId = from.getProperty("tablestore.access_key_id");
            if (accessKeyId == null) {
                logger.error("{} is required.", (Object)"tablestore.access_key_id");
                throw new IllegalArgumentException("tablestore.access_key_id is required.");
            }
            String accessKeySecret = from.getProperty("tablestore.access_key_secret");
            if (accessKeySecret == null) {
                logger.error("{} is required.", (Object)"tablestore.access_key_secret");
                throw new IllegalArgumentException("tablestore.access_key_secret is required.");
            }
            Credential cred = new Credential(accessKeyId, accessKeySecret, from.getProperty("tablestore.security_token"));
            com.aliyun.openservices.tablestore.hadoop.TableStoreInputFormat.setCredential((Configuration)jobConf, cred);
            String endpoint = from.getProperty("tablestore.endpoint");
            if (endpoint == null) {
                logger.error("{} is required.", (Object)"tablestore.endpoint");
                throw new IllegalArgumentException("tablestore.endpoint is required.");
            }
            String instance = from.getProperty("tablestore.instance");
            Endpoint ep = instance == null ? new Endpoint(endpoint) : new Endpoint(endpoint, instance);
            com.aliyun.openservices.tablestore.hadoop.TableStoreInputFormat.setEndpoint((Configuration)jobConf, ep);
            String table = from.getProperty("tablestore.table.name");
            if (table == null) {
                logger.error("{} is required.", (Object)"tablestore.table.name");
                throw new IllegalArgumentException("tablestore.table.name is required.");
            }
            com.aliyun.openservices.tablestore.hadoop.TableStoreOutputFormat.setOutputTable((Configuration)jobConf, table);
            String t = from.getProperty("tablestore.max_update_batch_size");
            if (t != null) {
                try {
                    int batchSize = Integer.valueOf(t);
                    if (batchSize <= 0) {
                        logger.error("{} must be greater than 0.", (Object)"tablestore.max_update_batch_size");
                        throw new IllegalArgumentException("tablestore.max_update_batch_size must be greater than 0.");
                    }
                    com.aliyun.openservices.tablestore.hadoop.TableStoreOutputFormat.setMaxBatchSize((Configuration)jobConf, batchSize);
                }
                catch (NumberFormatException ex) {
                    logger.error("{} must be a positive integer.", (Object)"tablestore.max_update_batch_size");
                    throw new IllegalArgumentException("tablestore.max_update_batch_size must be a positive integer.");
                }
            }
            LinkedHashSet merged = new LinkedHashSet(jobConf.getStringCollection("tmpjars"));
            Job copy = new Job((Configuration)jobConf);
            TableMapReduceUtils.addDependencyJars(copy);
            merged.addAll(copy.getConfiguration().getStringCollection("tmpjars"));
            jobConf.set("tmpjars", StringUtils.arrayToString((String[])merged.toArray(new String[0])));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

