/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hive;

import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.Row;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.model.RowUpdateChange;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.aliyun.openservices.tablestore.hadoop.BatchWriteWritable;
import com.aliyun.openservices.tablestore.hadoop.RowWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreSerDe
extends AbstractSerDe {
    private static Logger logger = LoggerFactory.getLogger(TableStoreSerDe.class);
    private ArrayList<TypeInfo> columnTypes;
    private List<String> columnNames;
    private ObjectInspector inspector;
    private Configuration config;
    private Properties tableProperties;
    private TableMeta tableMeta;

    public void initialize(Configuration conf, Properties tableProps, Properties partProps) throws SerDeException {
        this.initialize(conf, tableProps);
    }

    public void initialize(Configuration conf, Properties props) throws SerDeException {
        logger.debug("table properties: {}", (Object)props);
        if (!"TRUE".equals(props.getProperty("EXTERNAL"))) {
            logger.error("only external table are supported so far: {}", (Object)props.getProperty("EXTERNAL"));
            throw new SerDeException("only external table are supported so far");
        }
        this.config = conf;
        this.tableProperties = props;
        this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)props.getProperty("columns.types"));
        String mapping = props.getProperty("tablestore.columns.mapping");
        if (mapping == null) {
            mapping = props.getProperty("columns");
        }
        this.columnNames = Arrays.asList(mapping.split(","));
        if (this.columnTypes.size() != this.columnNames.size()) {
            logger.error("# of column names is different with # of column types, {} {}", (Object)this.columnNames.size(), (Object)this.columnTypes.size());
            throw new SerDeException("# of column names is different with # of column types");
        }
        int sz = this.columnTypes.size();
        for (int i = 0; i < sz; ++i) {
            TypeInfo type = this.columnTypes.get(i);
            if (type instanceof PrimitiveTypeInfo) continue;
            logger.error("type of column {} is {}, but accepts only primitive types", (Object)this.columnNames.get(i), (Object)type.getCategory());
            throw new SerDeException("only primitive types are supported");
        }
        this.inspector = TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)((StructTypeInfo)TypeInfoFactory.getStructTypeInfo(Arrays.asList(props.getProperty("columns").split(",")), this.columnTypes)));
    }

    public Class<? extends Writable> getSerializedClass() {
        return BatchWriteWritable.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        StructObjectInspector soi = (StructObjectInspector)objInspector;
        List fieldMetas = soi.getAllStructFieldRefs();
        List values = soi.getStructFieldsDataAsList(obj);
        assert (fieldMetas.size() == values.size());
        assert (this.columnNames.size() == values.size());
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (int i = 0; i < values.size(); ++i) {
            String name = this.columnNames.get(i);
            Field field = new Field();
            field.name = name;
            field.meta = (StructField)fieldMetas.get(i);
            field.value = values.get(i);
            fields.put(name, field);
        }
        TableMeta tableMeta = this.fetchTableMeta();
        HashSet<String> pkeyNames = new HashSet<String>();
        ArrayList<PrimaryKeyColumn> pkeyCols = new ArrayList<PrimaryKeyColumn>();
        for (Object s : tableMeta.getPrimaryKeyList()) {
            String name = s.getName();
            pkeyNames.add(name);
            ColumnValue value = this.toColumnValue((Field)fields.get(name));
            if (value == null) {
                throw new SerDeException(((Object)((Object)this)).getClass().getName() + " cannot write to table " + this.tableProperties.get("tablestore.table.name") + " in TableStore, because primary-key column " + name + " is required.");
            }
            pkeyCols.add(new PrimaryKeyColumn(name, PrimaryKeyValue.fromColumn((ColumnValue)value)));
        }
        RowUpdateChange row = new RowUpdateChange(tableMeta.getTableName(), new PrimaryKey(pkeyCols));
        for (Field field : fields.values()) {
            String name = field.name;
            if (pkeyNames.contains(name)) continue;
            ColumnValue colVal = this.toColumnValue(field);
            if (colVal == null) {
                row.deleteColumns(name);
                continue;
            }
            row.put(name, colVal);
        }
        BatchWriteWritable batch = new BatchWriteWritable();
        batch.addRowChange((RowChange)row);
        return batch;
    }

    public SerDeStats getSerDeStats() {
        return null;
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (!(blob instanceof RowWritable)) {
            logger.error("deserialization expects {} but {} is given: {}", new Object[]{RowWritable.class.getName(), blob.getClass().getName(), blob});
            throw new SerDeException("fail to deserialize");
        }
        Row row = ((RowWritable)blob).getRow();
        logger.debug("deserializing {}", (Object)row);
        ArrayList<Object> res = new ArrayList<Object>(this.columnTypes.size());
        PrimaryKey pkey = row.getPrimaryKey();
        NavigableMap attrs = row.getColumnsMap();
        int sz = this.columnNames.size();
        for (int i = 0; i < sz; ++i) {
            String name = this.columnNames.get(i);
            PrimitiveTypeInfo type = (PrimitiveTypeInfo)this.columnTypes.get(i);
            res.add(TableStoreSerDe.extractHiveValue(pkey, attrs, name, type));
        }
        logger.debug("deserialized {}", (Object)row);
        return res;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    public List<TypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    private static Object extractHiveValue(PrimaryKey pkey, Map<String, NavigableMap<Long, ColumnValue>> attrs, String name, PrimitiveTypeInfo type) throws SerDeException {
        PrimaryKeyColumn pkCol = pkey.getPrimaryKeyColumn(name);
        if (pkCol != null) {
            PrimaryKeyValue val = pkCol.getValue();
            switch (val.getType()) {
                case INTEGER: {
                    switch (type.getPrimitiveCategory()) {
                        case LONG: {
                            return val.asLong();
                        }
                        case INT: {
                            return (int)val.asLong();
                        }
                        case SHORT: {
                            return (short)val.asLong();
                        }
                        case BYTE: {
                            return (byte)val.asLong();
                        }
                        case DOUBLE: {
                            return (double)val.asLong();
                        }
                        case FLOAT: {
                            return Float.valueOf(val.asLong());
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
                case STRING: {
                    switch (type.getPrimitiveCategory()) {
                        case STRING: {
                            return val.asString();
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
                case BINARY: {
                    switch (type.getPrimitiveCategory()) {
                        case BINARY: {
                            return val.asBinary();
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
            }
            logger.error("unknown data type on deserializing. row: {}, column: {}, value: {}", new Object[]{pkey, name, pkCol});
            throw new SerDeException("unknown data type of primary key");
        }
        NavigableMap<Long, ColumnValue> values = attrs.get(name);
        if (values != null) {
            Preconditions.checkArgument((values.size() == 1 ? 1 : 0) != 0, (Object)"only the latest version should be fetched");
            ColumnValue val = values.lastEntry().getValue();
            switch (val.getType()) {
                case INTEGER: {
                    switch (type.getPrimitiveCategory()) {
                        case LONG: {
                            return val.asLong();
                        }
                        case INT: {
                            return (int)val.asLong();
                        }
                        case SHORT: {
                            return (short)val.asLong();
                        }
                        case BYTE: {
                            return (byte)val.asLong();
                        }
                        case DOUBLE: {
                            return (double)val.asLong();
                        }
                        case FLOAT: {
                            return Float.valueOf(val.asLong());
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
                case DOUBLE: {
                    switch (type.getPrimitiveCategory()) {
                        case LONG: {
                            return (long)val.asDouble();
                        }
                        case INT: {
                            return (int)val.asDouble();
                        }
                        case SHORT: {
                            return (short)val.asDouble();
                        }
                        case BYTE: {
                            return (byte)val.asDouble();
                        }
                        case DOUBLE: {
                            return val.asDouble();
                        }
                        case FLOAT: {
                            return Float.valueOf((float)val.asDouble());
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
                case STRING: {
                    switch (type.getPrimitiveCategory()) {
                        case STRING: {
                            return val.asString();
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
                case BINARY: {
                    switch (type.getPrimitiveCategory()) {
                        case BINARY: {
                            return val.asBinary();
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
                case BOOLEAN: {
                    switch (type.getPrimitiveCategory()) {
                        case BOOLEAN: {
                            return val.asBoolean();
                        }
                    }
                    logger.error("data type mismatch. row: {}, column: {}, expect: {} real: {}", new Object[]{pkey, name, type.getPrimitiveCategory(), val.getType()});
                    throw new SerDeException("data type mismatch");
                }
            }
            logger.error("unknown data type on deserializing. row: {}, column: {}, value: {}", new Object[]{pkey, name, val});
            throw new SerDeException("unknown data type of primary key");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableMeta fetchTableMeta() {
        if (this.tableMeta == null) {
            SyncClientInterface ots = TableStore.newOtsClient(this.config);
            try {
                DescribeTableRequest req = new DescribeTableRequest(this.tableProperties.getProperty("tablestore.table.name"));
                DescribeTableResponse resp = ots.describeTable(req);
                this.tableMeta = resp.getTableMeta();
            }
            finally {
                ots.shutdown();
            }
        }
        return this.tableMeta;
    }

    private ColumnValue toColumnValue(Field field) throws SerDeException {
        Preconditions.checkNotNull((Object)field, (Object)"field must be nonnull.");
        ObjectInspector insp = field.meta.getFieldObjectInspector();
        Preconditions.checkNotNull((Object)(insp.getCategory() == ObjectInspector.Category.PRIMITIVE ? 1 : 0), (Object)"field must be primitive.");
        PrimitiveObjectInspector priInsp = (PrimitiveObjectInspector)insp;
        Object obj = priInsp.getPrimitiveJavaObject(field.value);
        if (obj == null) {
            return null;
        }
        switch (priInsp.getPrimitiveCategory()) {
            case LONG: 
            case INT: 
            case SHORT: 
            case BYTE: {
                return ColumnValue.fromLong((long)((Number)obj).longValue());
            }
            case DOUBLE: 
            case FLOAT: 
            case DECIMAL: {
                return ColumnValue.fromDouble((double)((Number)obj).doubleValue());
            }
            case BOOLEAN: {
                return ColumnValue.fromBoolean((boolean)((Boolean)obj));
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return ColumnValue.fromString((String)((String)obj));
            }
            case BINARY: {
                return ColumnValue.fromBinary((byte[])((byte[])obj));
            }
        }
        logger.error("TableStore column name: {}, JAVA type: {}, Hive type: {}", new Object[]{field.name, obj.getClass().getName(), priInsp.getPrimitiveCategory()});
        throw new SerDeException("Unsupported Hive type: " + priInsp.getPrimitiveCategory());
    }

    private class Field {
        public String name;
        public StructField meta;
        public Object value;

        private Field() {
        }
    }
}

