/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hive;

import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.aliyun.openservices.tablestore.hadoop.BatchWriteWritable;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.TableStore;
import com.aliyun.openservices.tablestore.hadoop.TableStoreRecordWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreOutputFormat
implements OutputFormat<Writable, BatchWriteWritable> {
    private static Logger logger = LoggerFactory.getLogger(TableStoreOutputFormat.class);

    public RecordWriter<Writable, BatchWriteWritable> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        String table = job.get("tablestore.table.name");
        Configuration conf = TableStoreOutputFormat.translateConfig((Configuration)job);
        SyncClientInterface ots = TableStore.newOtsClient(conf);
        final TableStoreRecordWriter writer = new TableStoreRecordWriter(ots, table);
        return new RecordWriter<Writable, BatchWriteWritable>(){

            public void write(Writable any, BatchWriteWritable rows) throws IOException {
                try {
                    writer.write((Object)any, (Object)rows);
                }
                catch (InterruptedException ex) {
                    throw new IOException("interrupted");
                }
            }

            public void close(Reporter reporter) throws IOException {
                try {
                    writer.close(null);
                }
                catch (InterruptedException ex) {
                    throw new IOException("interrupted");
                }
            }
        };
    }

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        Configuration dest = TableStoreOutputFormat.translateConfig((Configuration)job);
        com.aliyun.openservices.tablestore.hadoop.TableStoreOutputFormat.checkTable(dest);
    }

    private static Configuration translateConfig(Configuration from) {
        Configuration to = new Configuration();
        Credential cred = new Credential(from.get("tablestore.access_key_id"), from.get("tablestore.access_key_secret"), from.get("tablestore.security_token"));
        TableStore.setCredential(to, cred);
        String endpoint = from.get("tablestore.endpoint");
        String instance = from.get("tablestore.instance");
        Endpoint ep = instance == null ? new Endpoint(endpoint) : new Endpoint(endpoint, instance);
        TableStore.setEndpoint(to, ep);
        com.aliyun.openservices.tablestore.hadoop.TableStoreOutputFormat.setOutputTable(to, from.get("tablestore.table.name"));
        return to;
    }
}

