/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hive;

import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.model.DescribeTableRequest;
import com.alicloud.openservices.tablestore.model.DescribeTableResponse;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.PrimaryKeyColumn;
import com.alicloud.openservices.tablestore.model.PrimaryKeySchema;
import com.alicloud.openservices.tablestore.model.PrimaryKeyValue;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.alicloud.openservices.tablestore.model.TableMeta;
import com.aliyun.openservices.tablestore.hadoop.ComputeParams;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import com.aliyun.openservices.tablestore.hadoop.RowWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStore;
import com.aliyun.openservices.tablestore.hadoop.TableStoreFilterWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStoreRecordReader;
import com.aliyun.openservices.tablestore.hive.TableStoreInputSplit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreInputFormat
implements InputFormat<PrimaryKeyWritable, RowWritable> {
    private static Logger logger = LoggerFactory.getLogger(TableStoreInputFormat.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        List<InputSplit> splits;
        Configuration dest = TableStoreInputFormat.translateConfig((Configuration)job);
        SyncClientInterface ots = null;
        String columns = job.get("tablestore.columns.mapping");
        if (columns == null) {
            columns = job.get("columns");
        }
        logger.debug("columns to get: {}", (Object)columns);
        try {
            ots = TableStore.newOtsClient(dest);
            TableMeta meta = TableStoreInputFormat.fetchTableMeta(ots, job.get("tablestore.table.name"));
            RangeRowQueryCriteria criteria = TableStoreInputFormat.fetchCriteria(meta, columns);
            com.aliyun.openservices.tablestore.hadoop.TableStoreInputFormat.addCriteria(dest, criteria);
            dest.set("filters", new TableStoreFilterWritable(new Filter(Filter.CompareOperator.EMPTY_FILTER), Arrays.asList(columns.split(","))).serialize());
            splits = com.aliyun.openservices.tablestore.hadoop.TableStoreInputFormat.getSplits(dest, ots);
        }
        finally {
            if (ots != null) {
                ots.shutdown();
                ots = null;
            }
        }
        org.apache.hadoop.mapred.InputSplit[] res = new org.apache.hadoop.mapred.InputSplit[splits.size()];
        JobContext jobContext = ShimLoader.getHadoopShims().newJobContext(new Job((Configuration)job));
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)jobContext);
        int i = 0;
        for (InputSplit split : splits) {
            res[i] = new TableStoreInputSplit((com.aliyun.openservices.tablestore.hadoop.TableStoreInputSplit)split, tablePaths[0]);
            ++i;
        }
        return res;
    }

    private static Configuration translateConfig(Configuration from) {
        Configuration to = new Configuration();
        Credential cred = new Credential(from.get("tablestore.access_key_id"), from.get("tablestore.access_key_secret"), from.get("tablestore.security_token"));
        TableStore.setCredential(to, cred);
        String endpoint = from.get("tablestore.endpoint");
        String instance = from.get("tablestore.instance");
        Endpoint ep = instance == null ? new Endpoint(endpoint) : new Endpoint(endpoint, instance);
        TableStore.setEndpoint(to, ep);
        TableStore.setTableName(to, from.get("tablestore.table.name"));
        ComputeParams computeParams = new ComputeParams(from.getInt("tablestore.max.split.count", 1000), from.getLong("tablestore.split.size.mbs", 100L), from.getTrimmed("tablestore.compute.mode", "KV"));
        TableStore.setComputeParams(to, computeParams);
        return to;
    }

    private static RangeRowQueryCriteria fetchCriteria(TableMeta meta, String strColumns) {
        RangeRowQueryCriteria res = new RangeRowQueryCriteria(meta.getTableName());
        res.setMaxVersions(1);
        ArrayList<PrimaryKeyColumn> lower = new ArrayList<PrimaryKeyColumn>();
        ArrayList<PrimaryKeyColumn> upper = new ArrayList<PrimaryKeyColumn>();
        for (PrimaryKeySchema schema2 : meta.getPrimaryKeyList()) {
            lower.add(new PrimaryKeyColumn(schema2.getName(), PrimaryKeyValue.INF_MIN));
            upper.add(new PrimaryKeyColumn(schema2.getName(), PrimaryKeyValue.INF_MAX));
        }
        res.setInclusiveStartPrimaryKey(new PrimaryKey(lower));
        res.setExclusiveEndPrimaryKey(new PrimaryKey(upper));
        res.addColumnsToGet(strColumns.split(","));
        return res;
    }

    private static TableMeta fetchTableMeta(SyncClientInterface ots, String table) {
        DescribeTableResponse resp = ots.describeTable(new DescribeTableRequest(table));
        return resp.getTableMeta();
    }

    public RecordReader<PrimaryKeyWritable, RowWritable> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        Preconditions.checkNotNull((Object)split, (Object)"split must be nonnull");
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        Preconditions.checkArgument((boolean)(split instanceof TableStoreInputSplit), (Object)("split must be an instance of " + TableStoreInputSplit.class.getName()));
        TableStoreInputSplit tsSplit = (TableStoreInputSplit)split;
        Object conf = this.isHiveConfiguration((Configuration)job) ? TableStoreInputFormat.translateConfig((Configuration)job) : job;
        final TableStoreRecordReader rdr = new TableStoreRecordReader();
        rdr.initialize((InputSplit)tsSplit.getDelegated(), (Configuration)conf);
        return new RecordReader<PrimaryKeyWritable, RowWritable>(){

            public boolean next(PrimaryKeyWritable key, RowWritable value) throws IOException {
                boolean next = rdr.nextKeyValue();
                if (next) {
                    key.setPrimaryKey(rdr.getCurrentKey().getPrimaryKey());
                    value.setRow(rdr.getCurrentValue().getRow());
                }
                return next;
            }

            public PrimaryKeyWritable createKey() {
                return new PrimaryKeyWritable();
            }

            public RowWritable createValue() {
                return new RowWritable();
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public void close() throws IOException {
                rdr.close();
            }

            public float getProgress() throws IOException {
                return rdr.getProgress();
            }
        };
    }

    private boolean isHiveConfiguration(Configuration conf) {
        String endpoint = conf.get("tablestore.endpoint");
        return endpoint != null;
    }
}

