/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hive;

import com.aliyun.openservices.tablestore.hive.JarFinder;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;

public class TableMapReduceUtils {
    private static final Log LOG = LogFactory.getLog(TableMapReduceUtils.class);

    public static void addDependencyJars(Job job) throws IOException {
        try {
            TableMapReduceUtils.addDependencyJarsForClasses(job.getConfiguration(), job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getInputFormatClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getOutputFormatClass(), job.getPartitionerClass(), job.getCombinerClass());
        }
        catch (ClassNotFoundException var2) {
            throw new IOException(var2);
        }
    }

    public static void addDependencyJarsForClasses(Configuration conf, Class ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        Class[] var5 = classes;
        int var6 = classes.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            Class clazz = var5[var7];
            if (clazz == null) continue;
            Path path = TableMapReduceUtils.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                LOG.warn((Object)("Could not find jar for class " + clazz + " in order to ship it to the cluster."));
                continue;
            }
            if (!localFs.exists(path)) {
                LOG.warn((Object)("Could not validate jar file " + path + " for class " + clazz));
                continue;
            }
            jars.add(path.toString());
        }
        if (!jars.isEmpty()) {
            conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
        }
    }

    private static Path findOrCreateJar(Class<?> my_class, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = TableMapReduceUtils.findContainingJar(my_class, packagedClasses);
        if (null == jar || jar.isEmpty()) {
            jar = TableMapReduceUtils.getJar(my_class);
            TableMapReduceUtils.updateMap(jar, packagedClasses);
        }
        if (null != jar && !jar.isEmpty()) {
            LOG.debug((Object)String.format("For class %s, using jar %s", my_class.getName(), jar));
            return new Path(jar).makeQualified(fs);
        }
        return null;
    }

    private static String findContainingJar(Class<?> my_class, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        if (loader != null) {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        return packagedClasses.get(class_file);
    }

    private static String getJar(Class<?> my_class) {
        String ret = null;
        try {
            ret = JarFinder.getJar(my_class);
            return ret;
        }
        catch (Exception var3) {
            throw new RuntimeException("getJar invocation failed.", var3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        if (null != jar && !jar.isEmpty()) {
            ZipFile zip = null;
            try {
                zip = new ZipFile(jar);
                Enumeration<? extends ZipEntry> iter = zip.entries();
                while (iter.hasMoreElements()) {
                    ZipEntry entry = iter.nextElement();
                    if (!entry.getName().endsWith("class")) continue;
                    packagedClasses.put(entry.getName(), jar);
                }
            }
            finally {
                if (null != zip) {
                    zip.close();
                }
            }
        }
    }
}

