/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hive;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class JarFinder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyToZipStream(File file, ZipEntry entry, ZipOutputStream zos) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            zos.putNextEntry(entry);
            byte[] arr = new byte[4096];
            int read = is.read(arr);
            while (read > -1) {
                zos.write(arr, 0, read);
                read = is.read(arr);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                zos.closeEntry();
            }
        }
    }

    public static void jarDir(File dir, String relativePath, ZipOutputStream zos) throws IOException {
        Preconditions.checkNotNull((Object)relativePath, (Object)"relativePath");
        Preconditions.checkNotNull((Object)zos, (Object)"zos");
        File manifestFile = new File(dir, "META-INF/MANIFEST.MF");
        ZipEntry manifestEntry = new ZipEntry("META-INF/MANIFEST.MF");
        if (!manifestFile.exists()) {
            zos.putNextEntry(manifestEntry);
            new Manifest().write(new BufferedOutputStream(zos));
            zos.closeEntry();
        } else {
            JarFinder.copyToZipStream(manifestFile, manifestEntry, zos);
        }
        zos.closeEntry();
        JarFinder.zipDir(dir, relativePath, zos, true);
        zos.close();
    }

    private static void zipDir(File dir, String relativePath, ZipOutputStream zos, boolean start) throws IOException {
        String[] dirList = dir.list();
        if (dirList != null) {
            String[] var5 = dirList;
            int var6 = dirList.length;
            for (int var7 = 0; var7 < var6; ++var7) {
                String filePath;
                String aDirList = var5[var7];
                File f = new File(dir, aDirList);
                if (f.isHidden()) continue;
                if (f.isDirectory()) {
                    if (!start) {
                        ZipEntry dirEntry = new ZipEntry(relativePath + f.getName() + "/");
                        zos.putNextEntry(dirEntry);
                        zos.closeEntry();
                    }
                    filePath = f.getPath();
                    File file = new File(filePath);
                    JarFinder.zipDir(file, relativePath + f.getName() + "/", zos, false);
                    continue;
                }
                filePath = relativePath + f.getName();
                if (filePath.equals("META-INF/MANIFEST.MF")) continue;
                ZipEntry anEntry = new ZipEntry(filePath);
                JarFinder.copyToZipStream(f, anEntry, zos);
            }
        }
    }

    private static void createJar(File dir, File jarFile) throws IOException {
        Preconditions.checkNotNull((Object)dir, (Object)"dir");
        Preconditions.checkNotNull((Object)jarFile, (Object)"jarFile");
        File jarDir = jarFile.getParentFile();
        if (!jarDir.exists() && !jarDir.mkdirs()) {
            throw new IOException(MessageFormat.format("could not create dir [{0}]", jarDir));
        }
        try (FileOutputStream fos = new FileOutputStream(jarFile);
             JarOutputStream jos = new JarOutputStream(fos);){
            JarFinder.jarDir(dir, "", jos);
        }
    }

    public static String getJar(Class klass) {
        Preconditions.checkNotNull((Object)klass, (Object)"klass");
        ClassLoader loader = klass.getClassLoader();
        if (loader != null) {
            String class_file = klass.getName().replaceAll("\\.", "/") + ".class";
            try {
                Enumeration<URL> itr = loader.getResources(class_file);
                while (itr.hasMoreElements()) {
                    URL url = itr.nextElement();
                    String path = url.getPath();
                    if (path.startsWith("file:")) {
                        path = path.substring("file:".length());
                    }
                    path = URLDecoder.decode(path, "UTF-8");
                    if ("jar".equals(url.getProtocol())) {
                        path = URLDecoder.decode(path, "UTF-8");
                        return path.replaceAll("!.*$", "");
                    }
                    if (!"file".equals(url.getProtocol())) continue;
                    String klassName = klass.getName();
                    klassName = klassName.replace(".", "/") + ".class";
                    path = path.substring(0, path.length() - klassName.length());
                    File baseDir = new File(path);
                    File testDir = new File(System.getProperty("test.build.dir", "target/test-dir"));
                    if (!(testDir = testDir.getAbsoluteFile()).exists()) {
                        testDir.mkdirs();
                    }
                    File tempJar = File.createTempFile("hadoop-", "", testDir);
                    tempJar = new File(tempJar.getAbsolutePath() + ".jar");
                    tempJar.deleteOnExit();
                    JarFinder.createJar(baseDir, tempJar);
                    return tempJar.getAbsolutePath();
                }
            }
            catch (IOException var10) {
                throw new RuntimeException(var10);
            }
        }
        return null;
    }
}

