/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit;
import com.alicloud.openservices.tablestore.model.Split;
import com.aliyun.openservices.tablestore.hadoop.ComputeSplitWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStoreFilterWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.io.Writable;

public class TableStoreSplitWritable
implements Writable {
    private TablestoreSplit split;

    public TableStoreSplitWritable() {
    }

    public TableStoreSplitWritable(TablestoreSplit split) {
        this.split = split;
    }

    public void write(DataOutput out) throws IOException {
        out.write(120);
        out.writeUTF(this.split.getType().name());
        out.writeUTF(this.split.getSplitName());
        out.writeUTF(this.split.getTableName());
        if (this.split.getKvSplit() != null) {
            new ComputeSplitWritable(this.split.getKvSplit()).write(out);
        } else {
            new ComputeSplitWritable(this.split.getSessionId(), this.split.getSplitId(), this.split.getMaxParallel()).write(out);
        }
        new TableStoreFilterWritable(this.split.getFilter(), this.split.getRequiredColumns()).write(out);
        List geoColumnNames = this.split.getGeoColumnNames();
        if (geoColumnNames == null) {
            out.writeInt(0);
        } else {
            out.writeInt(geoColumnNames.size());
            for (String columnName : geoColumnNames) {
                out.writeUTF(columnName);
            }
        }
    }

    public static TableStoreSplitWritable read(DataInput in) throws IOException {
        TableStoreSplitWritable sw = new TableStoreSplitWritable();
        sw.readFields(in);
        return sw;
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 120) {
            throw new IOException("broken input stream");
        }
        this.split = TableStoreSplitWritable.readSplit(in);
    }

    static TablestoreSplit readSplit(DataInput in) throws IOException {
        TablestoreSplit.SplitType splitType = TablestoreSplit.SplitType.valueOf((String)in.readUTF());
        String splitName = in.readUTF();
        String tableName = in.readUTF();
        ComputeSplitWritable splitWritable = ComputeSplitWritable.read(in);
        Split kvSplit = splitWritable.getSplit();
        TableStoreFilterWritable fw = TableStoreFilterWritable.read(in);
        int geoColumnSize = in.readInt();
        ArrayList<String> geoColumnNames = new ArrayList<String>(geoColumnSize);
        for (int i = 0; i < geoColumnSize; ++i) {
            geoColumnNames.add(in.readUTF());
        }
        TablestoreSplit rtSplit = new TablestoreSplit(splitType, fw.getFilter(), fw.getRequiredColumns(), splitWritable.getSessionId(), splitWritable.getSplitId(), splitWritable.getMaxParallel(), geoColumnNames);
        rtSplit.setSplitName(splitName);
        rtSplit.setTableName(tableName);
        rtSplit.setKvSplit(kvSplit);
        return rtSplit;
    }

    public TablestoreSplit getSplit() {
        return this.split;
    }

    public void setSplit(TablestoreSplit split) {
        this.split = split;
    }
}

