/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.ClientException;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.aliyun.openservices.tablestore.hadoop.BatchWriteWritable;
import com.aliyun.openservices.tablestore.hadoop.SinkConfig;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreRecordWriterV2
extends RecordWriter<Writable, BatchWriteWritable> {
    private static final Logger logger = LoggerFactory.getLogger(TableStoreRecordWriterV2.class);
    private TableStoreWriter ots;
    private AtomicLong rowCounter = new AtomicLong(0L);
    private Deque<RowChange> waitingRows = new ArrayDeque<RowChange>();
    private int maxBatchCount;
    private boolean isIgnoreOnFailureEnabled;

    public TableStoreRecordWriterV2(TableStoreWriter ots, SinkConfig sinkConfig) {
        Preconditions.checkNotNull((Object)ots, (Object)"ots client must be nonnull.");
        this.ots = ots;
        this.ots.setResultCallback((TableStoreCallback)new TableStoreCallback<RowChange, RowWriteResult>(){

            public void onCompleted(RowChange req, RowWriteResult res) {
                TableStoreRecordWriterV2.this.rowCounter.incrementAndGet();
            }

            public void onFailed(RowChange req, Exception ex) {
                logger.error("Batch write failed because client write failed, row change: {}, exception: {}", (Object)req, (Object)ex);
                if (!TableStoreRecordWriterV2.this.isIgnoreOnFailureEnabled) {
                    TableStoreRecordWriterV2.this.waitingRows.addFirst(req);
                    throw new RuntimeException("Task for batch write failed", ex);
                }
            }
        });
        this.maxBatchCount = sinkConfig.getWriterMaxBatchCount();
        this.isIgnoreOnFailureEnabled = sinkConfig.isIgnoreOnFailureEnabled();
        logger.debug("Max batch size: {}", (Object)this.maxBatchCount);
        logger.debug("Whether ignore on failure is enabled: {}", (Object)this.isIgnoreOnFailureEnabled);
    }

    public void write(Writable writable, BatchWriteWritable batchWriteWritable) throws IOException, InterruptedException {
        List<RowChange> rows = batchWriteWritable.getRowChanges();
        for (RowChange row : rows) {
            this.waitingRows.addLast(row);
        }
        while (this.waitingRows.size() >= this.maxBatchCount) {
            this.batchWrite();
        }
    }

    private void batchWrite() {
        block4: {
            ArrayList<RowChange> rows = new ArrayList<RowChange>();
            for (int i = 0; i < this.maxBatchCount && !this.waitingRows.isEmpty(); ++i) {
                RowChange row = this.waitingRows.pollFirst();
                rows.add(row);
            }
            ArrayList dirtyRows = new ArrayList();
            try {
                this.ots.addRowChange(rows, dirtyRows);
            }
            catch (ClientException e) {
                if (dirtyRows.size() <= 0) break block4;
                logger.error("Batch write failed because it contains dirty rows, count: {}, sample dirty row change: {}", (Object)dirtyRows.size(), dirtyRows.get(0));
                if (this.isIgnoreOnFailureEnabled) break block4;
                for (RowChange dirtyRow : dirtyRows) {
                    this.waitingRows.addFirst(dirtyRow);
                }
                throw new RuntimeException("Task for Batch write failed");
            }
        }
    }

    public void close(TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        while (!this.waitingRows.isEmpty()) {
            this.batchWrite();
        }
        this.ots.close();
        logger.info("This task wrote {} rows", (Object)this.rowCounter);
    }
}

