/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.ecosystem.FilterPushdownConfig;
import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Row;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.FilterPushdownConfigSerialize;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import com.aliyun.openservices.tablestore.hadoop.RowWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStoreInputSplit;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreRecordReader
extends RecordReader<PrimaryKeyWritable, RowWritable> {
    private static final Logger logger = LoggerFactory.getLogger(TableStoreRecordReader.class);
    private static SyncClient ots;
    private PrimaryKey currentKey;
    private Row currentValue;
    private Iterator<Row> results;
    private long rowCounter;

    public void close() {
        this.currentKey = null;
        this.currentValue = null;
        this.results = null;
        this.rowCounter = 0L;
    }

    public PrimaryKeyWritable getCurrentKey() {
        return new PrimaryKeyWritable(this.currentKey);
    }

    public RowWritable getCurrentValue() {
        return new RowWritable(this.currentValue);
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean nextKeyValue() {
        if (!this.results.hasNext()) {
            logger.info("total rows: {}", (Object)this.rowCounter);
            return false;
        }
        this.currentValue = this.results.next();
        this.currentKey = this.currentValue.getPrimaryKey();
        ++this.rowCounter;
        if (this.rowCounter % 1000L == 0L) {
            logger.info("deal with rows: {}", (Object)this.rowCounter);
        }
        return true;
    }

    public void initialize(InputSplit split, TaskAttemptContext ctx) {
        this.initialize(split, ctx.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initialize(InputSplit split, Configuration cfg) {
        this.close();
        String in = cfg.get("TABLESTORE_CREDENTIAL");
        Preconditions.checkNotNull((Object)in, (Object)"Must set \"TABLESTORE_CREDENTIAL\"");
        Credential cred = Credential.deserialize(in);
        String in2 = cfg.get("TABLESTORE_ENDPOINT");
        Preconditions.checkNotNull((Object)in2, (Object)"Must set \"TABLESTORE_ENDPOINT\"");
        Endpoint ep = Endpoint.deserialize(in2);
        Class<TableStoreRecordReader> in3 = cfg.get("FILTER_PUSHDOWN_CONFIG");
        FilterPushdownConfigSerialize filterPushdownConfigSerialize = in3 != null && !((String)((Object)in3)).isEmpty() ? FilterPushdownConfigSerialize.deserialize((String)((Object)in3)) : new FilterPushdownConfigSerialize(false, false);
        if (cred.securityToken == null) {
            if (ots == null) {
                in3 = TableStoreRecordReader.class;
                // MONITORENTER : com.aliyun.openservices.tablestore.hadoop.TableStoreRecordReader.class
                if (ots == null) {
                    ots = new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance);
                }
                // MONITOREXIT : in3
            }
        } else if (ots == null) {
            in3 = TableStoreRecordReader.class;
            // MONITORENTER : com.aliyun.openservices.tablestore.hadoop.TableStoreRecordReader.class
            if (ots == null) {
                ots = new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance, cred.securityToken);
            }
            // MONITOREXIT : in3
        }
        TablestoreSplit tsSplit = ((TableStoreInputSplit)split).getSplit();
        tsSplit.initial(ots);
        this.results = tsSplit.getRowIterator((SyncClientInterface)ots, new FilterPushdownConfig(filterPushdownConfigSerialize.pushRangeLong, filterPushdownConfigSerialize.pushRangeString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutdown() {
        if (ots == null) return;
        Class<TableStoreRecordReader> clazz = TableStoreRecordReader.class;
        synchronized (TableStoreRecordReader.class) {
            if (ots == null) return;
            logger.info("shutdown ots client in tablestore record reader");
            ots.shutdown();
            ots = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

