/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit;
import com.aliyun.openservices.tablestore.hadoop.TableStoreSplitWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;

public class TableStoreInputSplit
extends InputSplit
implements Writable {
    private TablestoreSplit split;

    public TableStoreInputSplit() {
    }

    public TableStoreInputSplit(TablestoreSplit split) {
        this.split = split;
    }

    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.split, (Object)"split should not be null.");
        new TableStoreSplitWritable(this.split).write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.split = TableStoreSplitWritable.read(in).getSplit();
    }

    public static TableStoreInputSplit read(DataInput in) throws IOException {
        TableStoreInputSplit w = new TableStoreInputSplit();
        w.readFields(in);
        return w;
    }

    public TablestoreSplit getSplit() {
        return this.split;
    }
}

