/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.ecosystem.ComputeParameters;
import com.alicloud.openservices.tablestore.ecosystem.DefaultTablestoreSplitManager;
import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.ecosystem.ITablestoreSplit;
import com.alicloud.openservices.tablestore.ecosystem.ITablestoreSplitManager;
import com.alicloud.openservices.tablestore.ecosystem.TablestoreSplit;
import com.alicloud.openservices.tablestore.model.Direction;
import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.aliyun.openservices.tablestore.hadoop.ComputeParams;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.MultiCriteria;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import com.aliyun.openservices.tablestore.hadoop.RowWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStore;
import com.aliyun.openservices.tablestore.hadoop.TableStoreFilterWritable;
import com.aliyun.openservices.tablestore.hadoop.TableStoreInputSplit;
import com.aliyun.openservices.tablestore.hadoop.TableStoreRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStoreInputFormat
extends InputFormat<PrimaryKeyWritable, RowWritable> {
    private static final String CRITERIA = "TABLESTORE_CRITERIA";
    public static final String TABLE_NAME = "tableName";
    public static final String COMPUTE_PARAMS = "computeParams";
    public static final String FILTER = "filters";
    private static final Logger LOG = LoggerFactory.getLogger(TableStoreInputFormat.class);
    private static SyncClientInterface ots;
    private static ITablestoreSplitManager splitManager;

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret) {
        TableStore.setCredential(job, accessKeyId, accessKeySecret);
    }

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret, String securityToken) {
        TableStore.setCredential(job, accessKeyId, accessKeySecret, securityToken);
    }

    public static void setCredential(Configuration conf, Credential cred) {
        TableStore.setCredential(conf, cred);
    }

    public static void setEndpoint(JobContext job, String endpoint) {
        TableStore.setEndpoint(job, endpoint);
    }

    public static void setEndpoint(JobContext job, String endpoint, String instance) {
        TableStore.setEndpoint(job, endpoint, instance);
    }

    public static void setEndpoint(Configuration conf, Endpoint ep) {
        TableStore.setEndpoint(conf, ep);
    }

    public static void addCriteria(JobContext job, RangeRowQueryCriteria criteria) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStoreInputFormat.addCriteria(job.getConfiguration(), criteria);
    }

    public static void addCriteria(Configuration conf, RangeRowQueryCriteria criteria) {
        Preconditions.checkNotNull((Object)criteria, (Object)"criteria must be nonnull");
        Preconditions.checkArgument((criteria.getDirection() == Direction.FORWARD ? 1 : 0) != 0, (Object)"criteria must be forward");
        String cur = conf.get(CRITERIA);
        MultiCriteria cri = null;
        cri = cur == null ? new MultiCriteria() : MultiCriteria.deserialize(cur);
        cri.addCriteria(criteria);
        conf.set(CRITERIA, cri.serialize());
        conf.set(TABLE_NAME, criteria.getTableName());
    }

    public static void clearCriteria(JobContext job) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStoreInputFormat.clearCriteria(job.getConfiguration());
    }

    public static void clearCriteria(Configuration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        conf.unset(CRITERIA);
    }

    public RecordReader<PrimaryKeyWritable, RowWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new TableStoreRecordReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        if (ots != null) return TableStoreInputFormat.getSplits(conf, ots);
        Class<TableStoreRecordReader> clazz = TableStoreRecordReader.class;
        synchronized (TableStoreRecordReader.class) {
            if (ots != null) return TableStoreInputFormat.getSplits(conf, ots);
            LOG.info("Initial ots client in tablestore inputformat");
            ots = TableStore.newOtsClient(conf);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return TableStoreInputFormat.getSplits(conf, ots);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static List<InputSplit> getSplits(Configuration conf, SyncClientInterface syncClient) {
        Object cp;
        TableStoreFilterWritable origFilter;
        Filter filter = new Filter(Filter.CompareOperator.EMPTY_FILTER);
        List<Object> requiredColumns = new ArrayList();
        if (conf.get(FILTER) != null && (origFilter = TableStoreFilterWritable.deserialize(conf.get(FILTER))) != null) {
            filter = origFilter.getFilter();
            requiredColumns = origFilter.getRequiredColumns();
            LOG.info("Set customed filter and requiredColumns: {}", requiredColumns);
        }
        ComputeParameters computeParams = new ComputeParameters();
        if (conf.get(COMPUTE_PARAMS) != null) {
            cp = ComputeParams.deserialize(conf.get(COMPUTE_PARAMS));
            ComputeParameters.ComputeMode computeMode = ComputeParameters.ComputeMode.valueOf((String)((ComputeParams)cp).getComputeMode());
            LOG.info("Compute mode: {}, max splits: {}, split size: {}MB, seachIndexName: {}", new Object[]{((ComputeParams)cp).getComputeMode(), ((ComputeParams)cp).getMaxSplitsCount(), ((ComputeParams)cp).getSplitSizeInMBs(), ((ComputeParams)cp).getSearchIndexName()});
            if (computeMode == ComputeParameters.ComputeMode.Search && !((ComputeParams)cp).getSearchIndexName().isEmpty()) {
                LOG.info("Generate Search compute parameters");
                computeParams = new ComputeParameters(((ComputeParams)cp).getSearchIndexName(), ((ComputeParams)cp).getMaxSplitsCount());
            } else {
                computeParams = new ComputeParameters(((ComputeParams)cp).getMaxSplitsCount(), ((ComputeParams)cp).getSplitSizeInMBs(), computeMode);
            }
        }
        if (splitManager == null) {
            cp = TableStoreInputFormat.class;
            // MONITORENTER : com.aliyun.openservices.tablestore.hadoop.TableStoreInputFormat.class
            LOG.info("Initial split manager in tablestore inputformat");
            splitManager = new DefaultTablestoreSplitManager((SyncClient)syncClient);
            // MONITOREXIT : cp
        }
        List splits = splitManager.generateTablestoreSplits((SyncClient)syncClient, filter, conf.get(TABLE_NAME), computeParams, requiredColumns);
        ArrayList<InputSplit> inputSplits = new ArrayList<InputSplit>();
        Iterator iterator = splits.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                LOG.info("Generate {} splits", (Object)inputSplits.size());
                return inputSplits;
            }
            ITablestoreSplit split = (ITablestoreSplit)iterator.next();
            inputSplits.add(new TableStoreInputSplit((TablestoreSplit)split));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void shutdown() {
        if (ots == null) return;
        Class<TableStoreRecordReader> clazz = TableStoreRecordReader.class;
        synchronized (TableStoreRecordReader.class) {
            if (ots == null) return;
            LOG.info("shutdown ots client in tablestore inputformat");
            ots.shutdown();
            ots = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

