/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.ecosystem.Filter;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.aliyun.openservices.tablestore.hadoop.ColumnValueWritable;
import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.io.Writable;

public class TableStoreFilterWritable
implements Writable {
    private Filter filter;
    private List<String> requiredColumns;

    public TableStoreFilterWritable() {
    }

    public TableStoreFilterWritable(Filter filter, List<String> requiredColumns) {
        this.filter = filter;
        this.requiredColumns = requiredColumns;
    }

    public void write(DataOutput out) throws IOException {
        out.write(60);
        this.write(out, this.filter);
        this.write(out, this.requiredColumns);
    }

    public void write(DataOutput out, Filter filter) throws IOException {
        block20: {
            block21: {
                block19: {
                    if (!filter.isNested()) break block19;
                    out.write(78);
                    switch (filter.getLogicOperator()) {
                        case OR: {
                            out.write(85);
                            break;
                        }
                        case AND: {
                            out.write(83);
                            break;
                        }
                        case NOT: {
                            out.write(80);
                            break;
                        }
                        default: {
                            throw new AssertionError((Object)("unknown logical operator: " + filter.getLogicOperator().toString()));
                        }
                    }
                    out.writeInt(filter.getSubFilters().size());
                    for (Filter f : filter.getSubFilters()) {
                        this.write(out, f);
                    }
                    break block20;
                }
                if (!filter.getCompareOperator().equals((Object)Filter.CompareOperator.EMPTY_FILTER)) break block21;
                out.write(61);
                break block20;
            }
            out.write(65);
            switch (filter.getCompareOperator()) {
                case EQUAL: {
                    out.write(66);
                    break;
                }
                case NOT_EQUAL: {
                    out.write(68);
                    break;
                }
                case GREATER_THAN: {
                    out.write(71);
                    break;
                }
                case GREATER_EQUAL: {
                    out.write(72);
                    break;
                }
                case LESS_THAN: {
                    out.write(73);
                    break;
                }
                case LESS_EQUAL: {
                    out.write(74);
                    break;
                }
                case START_WITH: {
                    out.write(79);
                    break;
                }
                case IN: {
                    out.write(75);
                    break;
                }
                case IS_NULL: {
                    out.write(76);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown operator: " + filter.getCompareOperator().toString()));
                }
            }
            out.writeUTF(filter.getColumnName());
            if (filter.getColumnValue() != null) {
                new ColumnValueWritable(filter.getColumnValue()).write(out);
            }
            if (filter.getColumnValuesForInOperator() == null) break block20;
            out.writeInt(filter.getColumnValuesForInOperator().size());
            for (ColumnValue columnValue : filter.getColumnValuesForInOperator()) {
                new ColumnValueWritable(columnValue).write(out);
            }
        }
    }

    public void write(DataOutput out, List<String> requiredColumns) throws IOException {
        out.write(126);
        out.writeInt(requiredColumns.size());
        for (String column : requiredColumns) {
            out.writeUTF(column);
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 60) {
            throw new IOException("broken input stream");
        }
        this.filter = TableStoreFilterWritable.readFilter(in);
        this.requiredColumns = TableStoreFilterWritable.readRequiredColumns(in);
    }

    public static TableStoreFilterWritable read(DataInput in) throws IOException {
        TableStoreFilterWritable f = new TableStoreFilterWritable();
        f.readFields(in);
        return f;
    }

    private static Filter readFilter(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag == 65) {
            Filter.CompareOperator co;
            byte opTag = in.readByte();
            if (opTag == 66) {
                co = Filter.CompareOperator.EQUAL;
            } else if (opTag == 68) {
                co = Filter.CompareOperator.NOT_EQUAL;
            } else if (opTag == 71) {
                co = Filter.CompareOperator.GREATER_THAN;
            } else if (opTag == 72) {
                co = Filter.CompareOperator.GREATER_EQUAL;
            } else if (opTag == 73) {
                co = Filter.CompareOperator.LESS_THAN;
            } else if (opTag == 74) {
                co = Filter.CompareOperator.LESS_EQUAL;
            } else if (opTag == 79) {
                co = Filter.CompareOperator.START_WITH;
            } else if (opTag == 75) {
                co = Filter.CompareOperator.IN;
            } else if (opTag == 76) {
                co = Filter.CompareOperator.IS_NULL;
            } else {
                throw new IOException("broken input stream");
            }
            String name = in.readUTF();
            if (opTag == 76) {
                return new Filter(co, name);
            }
            if (opTag == 75) {
                int size = in.readInt();
                ArrayList<ColumnValue> values = new ArrayList<ColumnValue>();
                for (int i = 0; i < size; ++i) {
                    ColumnValue value = ColumnValueWritable.read(in).getColumnValue();
                    values.add(value);
                }
                return new Filter(co, name, values);
            }
            ColumnValue value = ColumnValueWritable.read(in).getColumnValue();
            return new Filter(co, name, value);
        }
        if (tag == 78) {
            Filter.LogicOperator lo;
            byte opTag = in.readByte();
            if (opTag == 83) {
                lo = Filter.LogicOperator.AND;
            } else if (opTag == 85) {
                lo = Filter.LogicOperator.OR;
            } else if (opTag == 80) {
                lo = Filter.LogicOperator.NOT;
            } else {
                throw new IOException("broken input stream");
            }
            int sz = in.readInt();
            ArrayList<Filter> subFilters = new ArrayList<Filter>(sz);
            for (int i = 0; i < sz; ++i) {
                subFilters.add(TableStoreFilterWritable.readFilter(in));
            }
            return new Filter(lo, subFilters);
        }
        if (tag == 61) {
            return Filter.emptyFilter();
        }
        throw new IOException("broken input stream");
    }

    private static List<String> readRequiredColumns(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 126) {
            throw new IOException("broken input stream");
        }
        int sz = in.readInt();
        ArrayList<String> requiredColumns = new ArrayList<String>(sz);
        for (int i = 0; i < sz; ++i) {
            requiredColumns.add(in.readUTF());
        }
        return requiredColumns;
    }

    public String serialize() {
        return Utils.serialize(this);
    }

    public static TableStoreFilterWritable deserialize(String in) {
        if (in == null) {
            return null;
        }
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            return TableStoreFilterWritable.read(din);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public Filter getFilter() {
        return this.filter;
    }

    public List<String> getRequiredColumns() {
        return this.requiredColumns;
    }
}

