/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.ClientConfiguration;
import com.alicloud.openservices.tablestore.DefaultTableStoreWriter;
import com.alicloud.openservices.tablestore.SyncClient;
import com.alicloud.openservices.tablestore.SyncClientInterface;
import com.alicloud.openservices.tablestore.TableStoreCallback;
import com.alicloud.openservices.tablestore.TableStoreWriter;
import com.alicloud.openservices.tablestore.core.auth.CredentialsProviderFactory;
import com.alicloud.openservices.tablestore.core.auth.ServiceCredentials;
import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.AlwaysRetryStrategy;
import com.alicloud.openservices.tablestore.model.DefaultRetryStrategy;
import com.alicloud.openservices.tablestore.model.RetryStrategy;
import com.alicloud.openservices.tablestore.model.RowChange;
import com.alicloud.openservices.tablestore.writer.RowWriteResult;
import com.alicloud.openservices.tablestore.writer.WriterConfig;
import com.alicloud.openservices.tablestore.writer.enums.BatchRequestType;
import com.alicloud.openservices.tablestore.writer.enums.WriteMode;
import com.aliyun.openservices.tablestore.hadoop.ComputeParams;
import com.aliyun.openservices.tablestore.hadoop.Credential;
import com.aliyun.openservices.tablestore.hadoop.Endpoint;
import com.aliyun.openservices.tablestore.hadoop.FilterPushdownConfigSerialize;
import com.aliyun.openservices.tablestore.hadoop.SinkConfig;
import com.aliyun.openservices.tablestore.hadoop.TableStoreInputFormat;
import com.aliyun.openservices.tablestore.hadoop.TableStoreRecordReader;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;

public class TableStore {
    public static final String ENDPOINT = "TABLESTORE_ENDPOINT";
    public static final String CREDENTIAL = "TABLESTORE_CREDENTIAL";
    public static final String FILTER_PUSHDOWN_CONFIG = "FILTER_PUSHDOWN_CONFIG";

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setCredential(job.getConfiguration(), new Credential(accessKeyId, accessKeySecret, null));
    }

    public static void setCredential(JobContext job, String accessKeyId, String accessKeySecret, String securityToken) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setCredential(job.getConfiguration(), new Credential(accessKeyId, accessKeySecret, securityToken));
    }

    public static void setCredential(Configuration conf, Credential cred) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        Preconditions.checkNotNull((Object)cred, (Object)"cred must be nonnull");
        conf.set(CREDENTIAL, cred.serialize());
    }

    public static void setEndpoint(JobContext job, String endpoint) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setEndpoint(job.getConfiguration(), new Endpoint(endpoint));
    }

    public static void setEndpoint(JobContext job, String endpoint, String instance) {
        Preconditions.checkNotNull((Object)job, (Object)"job must be nonnull");
        TableStore.setEndpoint(job.getConfiguration(), new Endpoint(endpoint, instance));
    }

    public static void setEndpoint(Configuration conf, Endpoint ep) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        Preconditions.checkNotNull((Object)ep, (Object)"ep must be nonnull");
        conf.set(ENDPOINT, ep.serialize());
    }

    public static void setFilterPushdownConfig(Configuration conf, FilterPushdownConfigSerialize filterPushdownConfigSerialize) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        if (filterPushdownConfigSerialize == null) {
            filterPushdownConfigSerialize = new FilterPushdownConfigSerialize(true, true);
        }
        conf.set(FILTER_PUSHDOWN_CONFIG, filterPushdownConfigSerialize.serialize());
    }

    public static void setComputeParams(Configuration conf, ComputeParams cp) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        Preconditions.checkNotNull((Object)cp, (Object)"cp must be nonnull");
        conf.set("computeParams", cp.serialize());
    }

    public static void setTableName(Configuration conf, String tableName) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf must be nonnull");
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName must be nonnull");
        conf.set("tableName", tableName);
    }

    public static SyncClientInterface newOtsClient(Configuration conf) {
        Credential cred = Credential.deserialize(conf.get(CREDENTIAL));
        Endpoint ep = Endpoint.deserialize(conf.get(ENDPOINT));
        ClientConfiguration clientCfg = new ClientConfiguration();
        clientCfg.setRetryStrategy((RetryStrategy)new DefaultRetryStrategy(10L, TimeUnit.SECONDS));
        if (cred.securityToken == null) {
            return new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance, clientCfg);
        }
        return new SyncClient(ep.endpoint, cred.accessKeyId, cred.accessKeySecret, ep.instance, clientCfg, cred.securityToken);
    }

    public static TableStoreWriter newOtsWriter(Configuration conf) {
        Credential cred = Credential.deserialize(conf.get(CREDENTIAL));
        Endpoint ep = Endpoint.deserialize(conf.get(ENDPOINT));
        String tableName = conf.get("TABLESTORE_OUTPUT_TABLE");
        SinkConfig sinkConfig = SinkConfig.deserialize(conf.get("TABLESTORE_SINK_CONFIG"));
        ClientConfiguration cc = new ClientConfiguration();
        if ("time".equals(sinkConfig.getClientRetryStrategy())) {
            cc.setRetryStrategy((RetryStrategy)new DefaultRetryStrategy((long)sinkConfig.getClientRetryTime(), TimeUnit.SECONDS));
        } else if ("count".equals(sinkConfig.getClientRetryStrategy())) {
            cc.setRetryStrategy((RetryStrategy)new AlwaysRetryStrategy(sinkConfig.getClientRetryCount(), sinkConfig.getClientRetryPause()));
        }
        cc.setIoThreadCount(sinkConfig.getClientIoPool());
        ServiceCredentials credentials = CredentialsProviderFactory.newDefaultCredentialProvider((String)cred.accessKeyId, (String)cred.accessKeySecret, (String)cred.securityToken).getCredentials();
        WriterConfig wc = new WriterConfig();
        if ("bulk_import".equals(sinkConfig.getWriterBatchRequestType())) {
            wc.setBatchRequestType(BatchRequestType.BULK_IMPORT);
        } else {
            wc.setBatchRequestType(BatchRequestType.BATCH_WRITE_ROW);
        }
        if (sinkConfig.isWriterBatchOrderGuaranteed()) {
            wc.setWriteMode(WriteMode.SEQUENTIAL);
            wc.setAllowDuplicatedRowInBatchRequest(false);
        } else {
            wc.setWriteMode(WriteMode.PARALLEL);
            wc.setAllowDuplicatedRowInBatchRequest(sinkConfig.isWriterBatchDuplicateAllowed());
        }
        wc.setBucketCount(sinkConfig.getWriterBucketNum());
        wc.setCallbackThreadCount(sinkConfig.getWriterCallbackPoolNum());
        wc.setCallbackThreadPoolQueueSize(sinkConfig.getWriterCallbackPoolQueueSize());
        wc.setConcurrency(sinkConfig.getWriterConcurrency());
        wc.setBufferSize(sinkConfig.getWriterBufferSize());
        wc.setFlushInterval(sinkConfig.getWriterFlushIntervalMs());
        wc.setMaxBatchSize(sinkConfig.getWriterMaxBatchSize());
        wc.setMaxBatchRowsCount(sinkConfig.getWriterMaxBatchCount());
        wc.setMaxColumnsCount(sinkConfig.getWriterMaxColumnCount());
        wc.setMaxAttrColumnSize(sinkConfig.getWriterMaxAttrSize());
        wc.setMaxPKColumnSize(sinkConfig.getWriterMaxPkSize());
        DefaultTableStoreWriter tablestoreWriter = new DefaultTableStoreWriter(ep.endpoint, credentials, ep.instance, tableName, wc, cc, (TableStoreCallback)new TableStoreCallback<RowChange, RowWriteResult>(){

            public void onCompleted(RowChange req, RowWriteResult res) {
            }

            public void onFailed(RowChange req, Exception ex) {
            }
        });
        return tablestoreWriter;
    }

    public static void shutdown() {
        TableStoreInputFormat.shutdown();
        TableStoreRecordReader.shutdown();
    }
}

