/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Writable;

public class SinkConfig
implements Writable {
    private String version;
    private String writerBatchRequestType;
    private boolean writerBatchOrderGuaranteed;
    private boolean writerBatchDuplicateAllowed;
    private String writerRowChangeType;
    private int writerBucketNum;
    private int writerCallbackPoolNum;
    private int writerCallbackPoolQueueSize;
    private int writerConcurrency;
    private int writerBufferSize;
    private int writerFlushIntervalMs;
    private int clientIoPool;
    private int writerMaxBatchSize;
    private int writerMaxBatchCount;
    private int writerMaxColumnCount;
    private int writerMaxAttrSize;
    private int writerMaxPkSize;
    private String clientRetryStrategy;
    private int clientRetryTime;
    private int clientRetryCount;
    private int clientRetryPause;
    private boolean ignoreOnFailureEnabled;

    public SinkConfig() {
    }

    public SinkConfig(String version, String writerBatchRequestType, boolean writerBatchOrderGuaranteed, boolean writerBatchDuplicateAllowed, String writerRowChangeType, int writerBucketNum, int writerCallbackPoolNum, int writerCallbackPoolQueueSize, int writerConcurrency, int writerBufferSize, int writerFlushIntervalMs, int clientIoPool, int writerMaxBatchSize, int writerMaxBatchCount, int writerMaxColumnCount, int writerMaxAttrSize, int writerMaxPkSize, String clientRetryStrategy, int clientRetryTime, int clientRetryCount, int clientRetryPause, boolean ignoreOnFailureEnabled) {
        this.version = version;
        this.writerBatchRequestType = writerBatchRequestType;
        this.writerBatchOrderGuaranteed = writerBatchOrderGuaranteed;
        this.writerBatchDuplicateAllowed = writerBatchDuplicateAllowed;
        this.writerRowChangeType = writerRowChangeType;
        this.writerBucketNum = writerBucketNum;
        this.writerCallbackPoolNum = writerCallbackPoolNum;
        this.writerCallbackPoolQueueSize = writerCallbackPoolQueueSize;
        this.writerConcurrency = writerConcurrency;
        this.writerBufferSize = writerBufferSize;
        this.writerFlushIntervalMs = writerFlushIntervalMs;
        this.clientIoPool = clientIoPool;
        this.writerMaxBatchSize = writerMaxBatchSize;
        this.writerMaxBatchCount = writerMaxBatchCount;
        this.writerMaxColumnCount = writerMaxColumnCount;
        this.writerMaxAttrSize = writerMaxAttrSize;
        this.writerMaxPkSize = writerMaxPkSize;
        this.clientRetryStrategy = clientRetryStrategy;
        this.clientRetryTime = clientRetryTime;
        this.clientRetryCount = clientRetryCount;
        this.clientRetryPause = clientRetryPause;
        this.ignoreOnFailureEnabled = ignoreOnFailureEnabled;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWriterBatchRequestType() {
        return this.writerBatchRequestType;
    }

    public boolean isWriterBatchOrderGuaranteed() {
        return this.writerBatchOrderGuaranteed;
    }

    public boolean isWriterBatchDuplicateAllowed() {
        return this.writerBatchDuplicateAllowed;
    }

    public String getWriterRowChangeType() {
        return this.writerRowChangeType;
    }

    public int getWriterBucketNum() {
        return this.writerBucketNum;
    }

    public int getWriterCallbackPoolNum() {
        return this.writerCallbackPoolNum;
    }

    public int getWriterCallbackPoolQueueSize() {
        return this.writerCallbackPoolQueueSize;
    }

    public int getWriterConcurrency() {
        return this.writerConcurrency;
    }

    public int getWriterBufferSize() {
        return this.writerBufferSize;
    }

    public int getWriterFlushIntervalMs() {
        return this.writerFlushIntervalMs;
    }

    public int getClientIoPool() {
        return this.clientIoPool;
    }

    public int getWriterMaxBatchSize() {
        return this.writerMaxBatchSize;
    }

    public int getWriterMaxBatchCount() {
        return this.writerMaxBatchCount;
    }

    public int getWriterMaxColumnCount() {
        return this.writerMaxColumnCount;
    }

    public int getWriterMaxAttrSize() {
        return this.writerMaxAttrSize;
    }

    public int getWriterMaxPkSize() {
        return this.writerMaxPkSize;
    }

    public String getClientRetryStrategy() {
        return this.clientRetryStrategy;
    }

    public int getClientRetryTime() {
        return this.clientRetryTime;
    }

    public int getClientRetryCount() {
        return this.clientRetryCount;
    }

    public int getClientRetryPause() {
        return this.clientRetryPause;
    }

    public boolean isIgnoreOnFailureEnabled() {
        return this.ignoreOnFailureEnabled;
    }

    public void write(DataOutput dataOutput) throws IOException {
        dataOutput.write(127);
        dataOutput.writeUTF(this.version);
        dataOutput.writeUTF(this.writerBatchRequestType);
        dataOutput.writeBoolean(this.writerBatchOrderGuaranteed);
        dataOutput.writeBoolean(this.writerBatchDuplicateAllowed);
        dataOutput.writeUTF(this.writerRowChangeType);
        dataOutput.writeInt(this.writerBucketNum);
        dataOutput.writeInt(this.writerCallbackPoolNum);
        dataOutput.writeInt(this.writerCallbackPoolQueueSize);
        dataOutput.writeInt(this.writerConcurrency);
        dataOutput.writeInt(this.writerBufferSize);
        dataOutput.writeInt(this.writerFlushIntervalMs);
        dataOutput.writeInt(this.clientIoPool);
        dataOutput.writeInt(this.writerMaxBatchSize);
        dataOutput.writeInt(this.writerMaxBatchCount);
        dataOutput.writeInt(this.writerMaxColumnCount);
        dataOutput.writeInt(this.writerMaxAttrSize);
        dataOutput.writeInt(this.writerMaxPkSize);
        dataOutput.writeUTF(this.clientRetryStrategy);
        dataOutput.writeInt(this.clientRetryTime);
        dataOutput.writeInt(this.clientRetryCount);
        dataOutput.writeInt(this.clientRetryPause);
        dataOutput.writeBoolean(this.ignoreOnFailureEnabled);
    }

    public void readFields(DataInput dataInput) throws IOException {
        byte tag = dataInput.readByte();
        if (tag != 127) {
            throw new IOException("broken input stream");
        }
        this.version = dataInput.readUTF();
        this.writerBatchRequestType = dataInput.readUTF();
        this.writerBatchOrderGuaranteed = dataInput.readBoolean();
        this.writerBatchDuplicateAllowed = dataInput.readBoolean();
        this.writerRowChangeType = dataInput.readUTF();
        this.writerBucketNum = dataInput.readInt();
        this.writerCallbackPoolNum = dataInput.readInt();
        this.writerCallbackPoolQueueSize = dataInput.readInt();
        this.writerConcurrency = dataInput.readInt();
        this.writerBufferSize = dataInput.readInt();
        this.writerFlushIntervalMs = dataInput.readInt();
        this.clientIoPool = dataInput.readInt();
        this.writerMaxBatchSize = dataInput.readInt();
        this.writerMaxBatchCount = dataInput.readInt();
        this.writerMaxColumnCount = dataInput.readInt();
        this.writerMaxAttrSize = dataInput.readInt();
        this.writerMaxPkSize = dataInput.readInt();
        this.clientRetryStrategy = dataInput.readUTF();
        this.clientRetryTime = dataInput.readInt();
        this.clientRetryCount = dataInput.readInt();
        this.clientRetryPause = dataInput.readInt();
        this.ignoreOnFailureEnabled = dataInput.readBoolean();
    }

    public String serialize() {
        return Utils.serialize(this);
    }

    public static SinkConfig deserialize(String in) {
        if (in == null) {
            return null;
        }
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            SinkConfig sinkConfig = new SinkConfig();
            sinkConfig.readFields(din);
            return sinkConfig;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

