/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.RowPutChange;
import com.aliyun.openservices.tablestore.hadoop.ColumnWritable;
import com.aliyun.openservices.tablestore.hadoop.ConditionWritable;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.hadoop.io.Writable;

public class RowPutChangeWritable
implements Writable,
Externalizable {
    private RowPutChange putRow;

    public RowPutChangeWritable() {
    }

    public RowPutChangeWritable(RowPutChange putRow) {
        Preconditions.checkNotNull((Object)putRow, (Object)"putRow must be nonnull.");
        this.putRow = putRow;
    }

    public RowPutChange getRowPutChange() {
        return this.putRow;
    }

    public void write(DataOutput out) throws IOException {
        out.writeUTF(this.putRow.getTableName());
        new PrimaryKeyWritable(this.putRow.getPrimaryKey()).write(out);
        new ConditionWritable(this.putRow.getCondition()).write(out);
        List cols = this.putRow.getColumnsToPut();
        out.writeInt(cols.size());
        for (Column col : cols) {
            new ColumnWritable(col).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        String tableName = in.readUTF();
        PrimaryKey pkey = PrimaryKeyWritable.read(in).getPrimaryKey();
        RowPutChange putRow = new RowPutChange(tableName, pkey);
        putRow.setCondition(ConditionWritable.read(in).getCondition());
        int attrSz = in.readInt();
        for (int j = 0; j < attrSz; ++j) {
            putRow.addColumn(ColumnWritable.read(in).getColumn());
        }
        this.putRow = putRow;
    }

    public static RowPutChangeWritable read(DataInput in) throws IOException {
        RowPutChangeWritable w = new RowPutChangeWritable();
        w.readFields(in);
        return w;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFields(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.write(out);
    }
}

