/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.model.RangeRowQueryCriteria;
import com.aliyun.openservices.tablestore.hadoop.RangeRowQueryCriteriaWritable;
import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Writable;

public class MultiCriteria
implements Writable {
    private List<RangeRowQueryCriteria> criteria = new ArrayList<RangeRowQueryCriteria>();

    public List<RangeRowQueryCriteria> getCriteria() {
        return Collections.unmodifiableList(this.criteria);
    }

    public void addCriteria(RangeRowQueryCriteria criteria) {
        this.criteria.add(criteria);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiCriteria)) {
            return false;
        }
        MultiCriteria a = (MultiCriteria)obj;
        return this.criteria.equals(a.criteria);
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(58);
        out.writeInt(this.criteria.size());
        for (RangeRowQueryCriteria c : this.criteria) {
            new RangeRowQueryCriteriaWritable(c).write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 58) {
            throw new IOException("broken input stream");
        }
        ArrayList<RangeRowQueryCriteria> newCriteria = new ArrayList<RangeRowQueryCriteria>();
        int sz = in.readInt();
        for (int i = 0; i < sz; ++i) {
            newCriteria.add(RangeRowQueryCriteriaWritable.read(in).getRangeRowQueryCriteria());
        }
        this.criteria = newCriteria;
    }

    public static MultiCriteria read(DataInput in) throws IOException {
        MultiCriteria w = new MultiCriteria();
        w.readFields(in);
        return w;
    }

    public String serialize() {
        return Utils.serialize(this);
    }

    public static MultiCriteria deserialize(String in) {
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            return MultiCriteria.read(din);
        }
        catch (IOException ex) {
            return null;
        }
    }
}

