/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.alicloud.openservices.tablestore.model.filter.ColumnPaginationFilter;
import com.alicloud.openservices.tablestore.model.filter.ColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.CompositeColumnValueFilter;
import com.alicloud.openservices.tablestore.model.filter.Filter;
import com.alicloud.openservices.tablestore.model.filter.SingleColumnValueFilter;
import com.aliyun.openservices.tablestore.hadoop.ColumnValueWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class FilterWritable
implements Writable {
    private Filter filter;

    public FilterWritable() {
    }

    public FilterWritable(Filter filter) {
        Preconditions.checkNotNull((Object)filter, (Object)"filter should not be null.");
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.filter, (Object)"filter must be nonnull.");
        out.write(60);
        FilterWritable.write(out, this.filter);
    }

    private static void write(DataOutput out, Filter filter) throws IOException {
        if (filter instanceof ColumnPaginationFilter) {
            ColumnPaginationFilter paging = (ColumnPaginationFilter)filter;
            out.write(63);
            out.writeInt(paging.getOffset());
            out.writeInt(paging.getLimit());
        } else if (filter instanceof SingleColumnValueFilter) {
            SingleColumnValueFilter single = (SingleColumnValueFilter)filter;
            out.write(65);
            switch (single.getOperator()) {
                case EQUAL: {
                    out.write(66);
                    break;
                }
                case NOT_EQUAL: {
                    out.write(68);
                    break;
                }
                case GREATER_THAN: {
                    out.write(71);
                    break;
                }
                case GREATER_EQUAL: {
                    out.write(72);
                    break;
                }
                case LESS_THAN: {
                    out.write(73);
                    break;
                }
                case LESS_EQUAL: {
                    out.write(74);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown operator: " + single.getOperator().toString()));
                }
            }
            out.writeUTF(single.getColumnName());
            out.writeBoolean(single.isPassIfMissing());
            out.writeBoolean(single.isLatestVersionsOnly());
            new ColumnValueWritable(single.getColumnValue()).write(out);
        } else if (filter instanceof CompositeColumnValueFilter) {
            CompositeColumnValueFilter comp = (CompositeColumnValueFilter)filter;
            out.write(78);
            switch (comp.getOperationType()) {
                case NOT: {
                    out.write(80);
                    break;
                }
                case AND: {
                    out.write(83);
                    break;
                }
                case OR: {
                    out.write(85);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown logical operator: " + comp.getOperationType().toString()));
                }
            }
            out.writeInt(comp.getSubFilters().size());
            for (Filter f : comp.getSubFilters()) {
                FilterWritable.write(out, f);
            }
        } else {
            throw new AssertionError((Object)("unknown filter type " + filter.getFilterType().toString()));
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 60) {
            throw new IOException("broken input stream");
        }
        this.filter = FilterWritable.readFilter(in);
    }

    static Filter readFilter(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag == 63) {
            int offset = in.readInt();
            int limit = in.readInt();
            return new ColumnPaginationFilter(limit, offset);
        }
        return FilterWritable.readColumnValueFilter(in, tag);
    }

    private static ColumnValueFilter readColumnValueFilter(DataInput in, byte tag) throws IOException {
        if (tag == 65) {
            SingleColumnValueFilter.CompareOperator op;
            byte opTag = in.readByte();
            if (opTag == 66) {
                op = SingleColumnValueFilter.CompareOperator.EQUAL;
            } else if (opTag == 68) {
                op = SingleColumnValueFilter.CompareOperator.NOT_EQUAL;
            } else if (opTag == 71) {
                op = SingleColumnValueFilter.CompareOperator.GREATER_THAN;
            } else if (opTag == 72) {
                op = SingleColumnValueFilter.CompareOperator.GREATER_EQUAL;
            } else if (opTag == 73) {
                op = SingleColumnValueFilter.CompareOperator.LESS_THAN;
            } else if (opTag == 74) {
                op = SingleColumnValueFilter.CompareOperator.LESS_EQUAL;
            } else {
                throw new IOException("broken input stream");
            }
            String name = in.readUTF();
            boolean passIfMissing = in.readBoolean();
            boolean latestVersionOnly = in.readBoolean();
            ColumnValue value = ColumnValueWritable.read(in).getColumnValue();
            return new SingleColumnValueFilter(name, op, value).setPassIfMissing(passIfMissing).setLatestVersionsOnly(latestVersionOnly);
        }
        if (tag == 78) {
            CompositeColumnValueFilter filter;
            byte opTag = in.readByte();
            if (opTag == 80) {
                filter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.NOT);
            } else if (opTag == 83) {
                filter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.AND);
            } else if (opTag == 85) {
                filter = new CompositeColumnValueFilter(CompositeColumnValueFilter.LogicOperator.OR);
            } else {
                throw new IOException("broken input stream");
            }
            int sz = in.readInt();
            for (int i = 0; i < sz; ++i) {
                byte nxtTag = in.readByte();
                ColumnValueFilter f = FilterWritable.readColumnValueFilter(in, nxtTag);
                filter.addFilter(f);
            }
            return filter;
        }
        throw new IOException("broken input stream");
    }

    public static FilterWritable read(DataInput in) throws IOException {
        FilterWritable w = new FilterWritable();
        w.readFields(in);
        return w;
    }
}

