/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Writable;

public class FilterPushdownConfigSerialize
implements Serializable,
Writable {
    public boolean pushRangeLong;
    public boolean pushRangeString;

    public FilterPushdownConfigSerialize() {
    }

    public FilterPushdownConfigSerialize(boolean pushRangeLong, boolean pushRangeString) {
        this.pushRangeLong = pushRangeLong;
        this.pushRangeString = pushRangeString;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(59);
        out.writeBoolean(this.pushRangeLong);
        out.writeBoolean(this.pushRangeString);
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 59) {
            throw new IOException("broken input stream");
        }
        this.pushRangeLong = in.readBoolean();
        this.pushRangeString = in.readBoolean();
    }

    public static FilterPushdownConfigSerialize read(DataInput in) throws IOException {
        FilterPushdownConfigSerialize w = new FilterPushdownConfigSerialize();
        w.readFields(in);
        return w;
    }

    public static FilterPushdownConfigSerialize deserialize(String in) {
        if (in == null) {
            return null;
        }
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            return FilterPushdownConfigSerialize.read(din);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public String serialize() {
        return Utils.serialize(this);
    }
}

