/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.model.PrimaryKey;
import com.alicloud.openservices.tablestore.model.Split;
import com.aliyun.openservices.tablestore.hadoop.PrimaryKeyWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ComputeSplitWritable
implements Writable {
    private Split split;
    private byte[] sessionId;
    private int splitId;
    private int maxParallel;

    public ComputeSplitWritable() {
    }

    public ComputeSplitWritable(byte[] sessionId, int splitId, int maxParallel) {
        this.sessionId = sessionId;
        this.splitId = splitId;
        this.maxParallel = maxParallel;
    }

    public ComputeSplitWritable(Split split) {
        this.split = split;
    }

    public void write(DataOutput out) throws IOException {
        out.write(121);
        if (this.split != null) {
            this.write(out, this.split);
        } else {
            this.write(out, this.sessionId, this.splitId);
        }
    }

    public void write(DataOutput out, Split split) throws IOException {
        out.writeByte(122);
        out.writeUTF(split.getLocation());
        new PrimaryKeyWritable(split.getLowerBound()).write(out);
        new PrimaryKeyWritable(split.getUpperBound()).write(out);
    }

    public void write(DataOutput out, byte[] sessionId, int splitId) throws IOException {
        out.writeByte(123);
        out.writeInt(sessionId.length);
        out.write(sessionId);
        out.writeInt(splitId);
        out.writeInt(this.maxParallel);
    }

    public static ComputeSplitWritable read(DataInput in) throws IOException {
        ComputeSplitWritable cw = new ComputeSplitWritable();
        cw.readFields(in);
        return cw;
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 121) {
            throw new IOException("broken input stream");
        }
        byte splitType = in.readByte();
        if (splitType == 122) {
            this.split = ComputeSplitWritable.readSplit(in);
        } else if (splitType == 123) {
            int len = in.readInt();
            this.sessionId = new byte[len];
            in.readFully(this.sessionId);
            this.splitId = in.readInt();
            this.maxParallel = in.readInt();
        } else {
            throw new IOException("broken input stream");
        }
    }

    private static Split readSplit(DataInput in) throws IOException {
        String location = in.readUTF();
        PrimaryKey lower = PrimaryKeyWritable.read(in).getPrimaryKey();
        PrimaryKey upper = PrimaryKeyWritable.read(in).getPrimaryKey();
        return new Split(location, lower, upper);
    }

    public Split getSplit() {
        return this.split;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public int getSplitId() {
        return this.splitId;
    }

    public int getMaxParallel() {
        return this.maxParallel;
    }
}

