/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.aliyun.openservices.tablestore.hadoop.Utils;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.io.Writable;

public class ComputeParams
implements Writable {
    private static final String COMPUTE_MODE_KV = "KV";
    private static final String COMPUTE_MODE_SEARCH = "Search";
    private static final String COMPUTE_MODE_AUTO = "Auto";
    private int maxSplitsCount;
    private long splitSizeInMBs;
    private String computeMode;
    private String searchIndexName = "";

    public ComputeParams() {
    }

    public ComputeParams(int maxSplitsCount, long splitSizeInMBs, String computeMode) {
        this.maxSplitsCount = maxSplitsCount;
        this.splitSizeInMBs = splitSizeInMBs;
        this.computeMode = computeMode;
    }

    public ComputeParams(String searchIndexName) {
        this.computeMode = COMPUTE_MODE_SEARCH;
        this.searchIndexName = searchIndexName;
    }

    public ComputeParams(String searchIndexName, int maxSplitsCount) {
        this.computeMode = COMPUTE_MODE_SEARCH;
        this.searchIndexName = searchIndexName;
        this.maxSplitsCount = maxSplitsCount;
    }

    public void write(DataOutput out) throws IOException {
        out.write(115);
        out.writeInt(this.maxSplitsCount);
        out.writeLong(this.splitSizeInMBs);
        out.writeUTF(this.computeMode);
        out.writeUTF(this.searchIndexName);
    }

    public void readFields(DataInput in) throws IOException {
        byte tag = in.readByte();
        if (tag != 115) {
            throw new IOException("broken input stream");
        }
        this.maxSplitsCount = in.readInt();
        this.splitSizeInMBs = in.readLong();
        this.computeMode = in.readUTF();
        this.searchIndexName = in.readUTF();
    }

    public static ComputeParams read(DataInput in) throws IOException {
        ComputeParams params = new ComputeParams();
        params.readFields(in);
        return params;
    }

    public String serialize() {
        return Utils.serialize(this);
    }

    public static ComputeParams deserialize(String in) {
        if (in == null) {
            return null;
        }
        byte[] buf = Base64.decodeBase64((String)in);
        ByteArrayInputStream is = new ByteArrayInputStream(buf);
        DataInputStream din = new DataInputStream(is);
        try {
            return ComputeParams.read(din);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public int getMaxSplitsCount() {
        return this.maxSplitsCount;
    }

    public long getSplitSizeInMBs() {
        return this.splitSizeInMBs;
    }

    public String getComputeMode() {
        return this.computeMode;
    }

    public String getSearchIndexName() {
        return this.searchIndexName;
    }
}

