/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.Column;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import com.aliyun.openservices.tablestore.hadoop.ColumnValueWritable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ColumnWritable
implements Writable {
    private Column column = null;

    public ColumnWritable() {
    }

    public ColumnWritable(Column col) {
        Preconditions.checkNotNull((Object)col, (Object)"The column should not be null.");
        this.column = col;
    }

    public Column getColumn() {
        return this.column;
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.column, (Object)"column should not be null.");
        if (this.column.hasSetTimestamp()) {
            out.writeByte(24);
        } else {
            out.writeByte(23);
        }
        out.writeUTF(this.column.getName());
        new ColumnValueWritable(this.column.getValue()).write(out);
        if (this.column.hasSetTimestamp()) {
            out.writeLong(this.column.getTimestamp());
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte tagColumn = in.readByte();
        if (tagColumn == 23) {
            String name = in.readUTF();
            ColumnValue val = ColumnValueWritable.read(in).getColumnValue();
            this.column = new Column(name, val);
        } else if (tagColumn == 24) {
            String name = in.readUTF();
            ColumnValue val = ColumnValueWritable.read(in).getColumnValue();
            long ts = in.readLong();
            this.column = new Column(name, val, ts);
        } else {
            throw new IOException("broken input stream");
        }
    }

    public static ColumnWritable read(DataInput in) throws IOException {
        ColumnWritable w = new ColumnWritable();
        w.readFields(in);
        return w;
    }
}

