/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.tablestore.hadoop;

import com.alicloud.openservices.tablestore.core.utils.Preconditions;
import com.alicloud.openservices.tablestore.model.ColumnValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

public class ColumnValueWritable
implements Writable {
    private ColumnValue columnValue = null;

    public ColumnValueWritable() {
    }

    public ColumnValueWritable(ColumnValue colVal) {
        Preconditions.checkNotNull((Object)colVal, (Object)"The column value should not be null.");
        this.columnValue = colVal;
    }

    public ColumnValue getColumnValue() {
        return this.columnValue;
    }

    public void write(DataOutput out) throws IOException {
        Preconditions.checkNotNull((Object)this.columnValue, (Object)"columnValue should not be null.");
        out.writeByte(20);
        switch (this.columnValue.getType()) {
            case INTEGER: {
                out.writeByte(9);
                out.writeLong(this.columnValue.asLong());
                break;
            }
            case STRING: {
                out.writeByte(6);
                out.writeUTF(this.columnValue.asString());
                break;
            }
            case BINARY: {
                out.writeByte(10);
                byte[] v = this.columnValue.asBinary();
                out.writeInt(v.length);
                out.write(v);
                break;
            }
            case DOUBLE: {
                out.writeByte(12);
                out.writeDouble(this.columnValue.asDouble());
                break;
            }
            case BOOLEAN: {
                out.writeByte(15);
                out.writeBoolean(this.columnValue.asBoolean());
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown ColumnType");
            }
        }
    }

    public void readFields(DataInput in) throws IOException {
        byte columnValueTag = in.readByte();
        if (columnValueTag != 20) {
            throw new IOException("broken input stream");
        }
        byte type = in.readByte();
        if (type == 9) {
            long v = in.readLong();
            this.columnValue = ColumnValue.fromLong((long)v);
        } else if (type == 6) {
            String v = in.readUTF();
            this.columnValue = ColumnValue.fromString((String)v);
        } else if (type == 10) {
            int len = in.readInt();
            byte[] v = new byte[len];
            in.readFully(v);
            this.columnValue = ColumnValue.fromBinary((byte[])v);
        } else if (type == 12) {
            double v = in.readDouble();
            this.columnValue = ColumnValue.fromDouble((double)v);
        } else if (type == 15) {
            boolean v = in.readBoolean();
            this.columnValue = ColumnValue.fromBoolean((boolean)v);
        } else {
            throw new IOException("broken input stream");
        }
    }

    public static ColumnValueWritable read(DataInput in) throws IOException {
        ColumnValueWritable w = new ColumnValueWritable();
        w.readFields(in);
        return w;
    }
}

