<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: table_store.proto

namespace Aliyun\OTS\ProtoBuffer\Protocol;

/**
 **
 * 表的状态变更只与用户的操作对应，内部的机器failover等状况不对应表的状态变更。
 * 有三个考虑：
 *     一是一般场景下用户只会在做了对表的修改操作后才会去检查表的状态；
 *     二是内部机器failover导致访问异常到用户能够查看到表的状态变更这两个时刻之间会有一段延迟，无法将表的不可服务状态与用户查看到的表的状态完全匹配上。
 *     三是内部机器failover后不能说是表的整个状态变更，而应该是partition的状态变更，对应表的状态就是PARTIAL_FAILOVER，这个partial的粒度无法体现，会让用户更加困惑。
 *
 * Protobuf enum <code>Aliyun\OTS\ProtoBuffer\Protocol\TableStatus</code>
 */
class TableStatus
{
    /**
     * 表处于可服务状态。
     *
     * Generated from protobuf enum <code>ACTIVE = 1;</code>
     */
    const ACTIVE = 1;
    /**
     * 用户通过UnloadTable将表禁用。
     *
     * Generated from protobuf enum <code>INACTIVE = 2;</code>
     */
    const INACTIVE = 2;
    /**
     * 表正在被创建，partition还未全部加载完毕；或者表刚从INACTIVE状态被Enable。
     *
     * Generated from protobuf enum <code>LOADING = 3;</code>
     */
    const LOADING = 3;
    /**
     * 表正在被删除（从delete table到partition完全unload的这段期间）或者表从ACTIVE状态被Unload。
     *
     * Generated from protobuf enum <code>UNLOADING = 4;</code>
     */
    const UNLOADING = 4;
    /**
     * 表正在被更新（table属性变更、预留吞吐量变更）。
     *
     * Generated from protobuf enum <code>UPDATING = 5;</code>
     */
    const UPDATING = 5;
}

