<?php
require (__DIR__ . '/../vendor/autoload.php');
require (__DIR__ . '/ExampleConfig.php');

use Aliyun\OTS\OTSClient as OTSClient;
use Aliyun\OTS\Consts\PrimaryKeyTypeConst;
use Aliyun\OTS\Consts\DefinedColumnTypeConst;
use Aliyun\OTS\Consts\IndexTypeConst;
use Aliyun\OTS\Consts\IndexUpdateModeConst;

$otsClient = new OTSClient (array (
    'EndPoint' => EXAMPLE_END_POINT,
    'AccessKeyID' => EXAMPLE_ACCESS_KEY_ID,
    'AccessKeySecret' => EXAMPLE_ACCESS_KEY_SECRET,
    'InstanceName' => EXAMPLE_INSTANCE_NAME
));

$request = array (
    'table_meta' => array (
        'table_name' => 'MyTable', // 表名为 MyTable
        'primary_key_schema' => array (
            array('PK0', PrimaryKeyTypeConst::CONST_INTEGER), // 第一个主键列（又叫分片键）名称为PK0, 类型为 INTEGER
            array('PK1', PrimaryKeyTypeConst::CONST_STRING)
        ),
        'defined_column' => array(
            array('col1', DefinedColumnTypeConst::DCT_STRING),
            array('col2', DefinedColumnTypeConst::DCT_INTEGER)
        )
    ), // 第二个主键列名称为PK1, 类型为STRING
    
    'reserved_throughput' => array (
        'capacity_unit' => array (
            'read' => 0, // 预留读写吞吐量设置为：0个读CU，和0个写CU
            'write' => 0
        )
    ),
    'table_options' => array(
        'time_to_live' => -1,   // 数据生命周期, -1表示永久，单位秒
        'max_versions' => 1,    // 最大数据版本
        'deviation_cell_version_in_sec' => 86400  // 数据有效版本偏差，单位秒
    ),
    'index_metas' => array(
        array( // 默认GlobalIndex
            'name' => 'CreateTableWithIndex1',
            'primary_key' => array('col1'),
            'defined_column' => array('col2')
        ),
        array( // 主动指定GlobalIndex，index_update_mode必须是ASYNC_INDEX
            'name' => 'CreateTableWithIndex2',
            'primary_key' => array('PK1'),
            'defined_column' => array('col1', 'col2'),
            'index_type' => IndexTypeConst::GLOBAL_INDEX,
            'index_update_mode' => IndexUpdateModeConst::ASYNC_INDEX
        ),
        array( // 主动指定LocalIndex，index_update_mode必须是SYNC_INDEX
            'name' => 'CreateTableWithLocalIndex',
            'primary_key' => array('PK0', 'col1'),
            'defined_column' => array('col2'),
            'index_type' => IndexTypeConst::LOCAL_INDEX,
            'index_update_mode' => IndexUpdateModeConst::SYNC_INDEX
        ),
    )
);
$otsClient->createTable ( $request );

