/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.statement;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.jdbc.statement.FieldNamedPreparedStatement;
import org.apache.flink.util.Preconditions;

public class FieldNamedPreparedStatementImpl
implements FieldNamedPreparedStatement {
    private final PreparedStatement statement;
    private final int[][] indexMapping;
    private final boolean isBatchMode;

    private FieldNamedPreparedStatementImpl(PreparedStatement statement, int[][] indexMapping, boolean isBatchMode) {
        this.statement = statement;
        this.indexMapping = indexMapping;
        this.isBatchMode = isBatchMode;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.statement.clearParameters();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    @Override
    public void addBatch() throws SQLException {
        if (!this.isBatchMode) {
            this.statement.executeUpdate();
        } else {
            this.statement.addBatch();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!this.isBatchMode) {
            return new int[0];
        }
        return this.statement.executeBatch();
    }

    @Override
    public void setNull(int fieldIndex, int sqlType) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setNull(index, sqlType);
        }
    }

    @Override
    public void setBoolean(int fieldIndex, boolean x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setBoolean(index, x);
        }
    }

    @Override
    public void setByte(int fieldIndex, byte x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setByte(index, x);
        }
    }

    @Override
    public void setShort(int fieldIndex, short x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setShort(index, x);
        }
    }

    @Override
    public void setInt(int fieldIndex, int x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setInt(index, x);
        }
    }

    @Override
    public void setLong(int fieldIndex, long x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setLong(index, x);
        }
    }

    @Override
    public void setFloat(int fieldIndex, float x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setFloat(index, x);
        }
    }

    @Override
    public void setDouble(int fieldIndex, double x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setDouble(index, x);
        }
    }

    @Override
    public void setBigDecimal(int fieldIndex, BigDecimal x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setBigDecimal(index, x);
        }
    }

    @Override
    public void setString(int fieldIndex, String x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setString(index, x);
        }
    }

    @Override
    public void setBytes(int fieldIndex, byte[] x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setBytes(index, x);
        }
    }

    @Override
    public void setDate(int fieldIndex, Date x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setDate(index, x);
        }
    }

    @Override
    public void setTime(int fieldIndex, Time x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setTime(index, x);
        }
    }

    @Override
    public void setTimestamp(int fieldIndex, Timestamp x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setTimestamp(index, x);
        }
    }

    @Override
    public void setObject(int fieldIndex, Object x) throws SQLException {
        for (int index : this.indexMapping[fieldIndex]) {
            this.statement.setObject(index, x);
        }
    }

    @Override
    public void close() throws SQLException {
        this.statement.close();
    }

    public static FieldNamedPreparedStatement prepareStatement(Connection connection, String sql, String[] fieldNames) throws SQLException {
        return FieldNamedPreparedStatementImpl.prepareStatement(connection, sql, fieldNames, true);
    }

    public static FieldNamedPreparedStatement prepareStatement(Connection connection, String sql, String[] fieldNames, boolean isBatchMode) throws SQLException {
        Preconditions.checkNotNull((Object)connection, (String)"connection must not be null.");
        Preconditions.checkNotNull((Object)sql, (String)"sql must not be null.");
        Preconditions.checkNotNull((Object)fieldNames, (String)"fieldNames must not be null.");
        if (sql.contains("?")) {
            throw new IllegalArgumentException("SQL statement must not contain ? character.");
        }
        HashMap<String, List<Integer>> parameterMap = new HashMap<String, List<Integer>>();
        String parsedSQL = FieldNamedPreparedStatementImpl.parseNamedStatement(sql, parameterMap);
        Preconditions.checkArgument((parameterMap.size() == fieldNames.length ? 1 : 0) != 0);
        int[][] indexMapping = new int[fieldNames.length][];
        for (int i = 0; i < fieldNames.length; ++i) {
            String fieldName = fieldNames[i];
            Preconditions.checkArgument((boolean)parameterMap.containsKey(fieldName), (Object)(fieldName + " doesn't exist in the parameters of SQL statement: " + sql));
            indexMapping[i] = parameterMap.get(fieldName).stream().mapToInt(v -> v).toArray();
        }
        return new FieldNamedPreparedStatementImpl(connection.prepareStatement(parsedSQL), indexMapping, isBatchMode);
    }

    public static String parseNamedStatement(String sql, Map<String, List<Integer>> paramMap) {
        StringBuilder parsedSql = new StringBuilder();
        int fieldIndex = 1;
        int length = sql.length();
        for (int i = 0; i < length; ++i) {
            char c = sql.charAt(i);
            if (':' == c) {
                int j;
                for (j = i + 1; j < length && (Character.isJavaIdentifierPart(sql.charAt(j)) || sql.charAt(j) == '.'); ++j) {
                }
                String parameterName = sql.substring(i + 1, j);
                Preconditions.checkArgument((!parameterName.isEmpty() ? 1 : 0) != 0, (Object)"Named parameters in SQL statement must not be empty.");
                paramMap.computeIfAbsent(parameterName, n -> new ArrayList()).add(fieldIndex);
                ++fieldIndex;
                i = j - 1;
                parsedSql.append('?');
                continue;
            }
            parsedSql.append(c);
        }
        return parsedSql.toString();
    }
}

