/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.jdbc.internal.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.jdbc.JdbcStatementBuilder;
import org.apache.flink.connector.jdbc.internal.executor.JdbcBatchStatementExecutor;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public final class InsertOrUpdateJdbcExecutor<R, K, V>
implements JdbcBatchStatementExecutor<R> {
    private static final Logger LOG = LoggerFactory.getLogger(InsertOrUpdateJdbcExecutor.class);
    private final String existSQL;
    private final String insertSQL;
    private final String updateSQL;
    private final JdbcStatementBuilder<K> existSetter;
    private final JdbcStatementBuilder<V> insertSetter;
    private final JdbcStatementBuilder<V> updateSetter;
    private final Function<R, K> keyExtractor;
    private final Function<R, V> valueMapper;
    private final Map<K, V> batch;
    private transient PreparedStatement existStatement;
    private transient PreparedStatement insertStatement;
    private transient PreparedStatement updateStatement;

    public InsertOrUpdateJdbcExecutor(@Nonnull String existSQL, @Nonnull String insertSQL, @Nonnull String updateSQL, @Nonnull JdbcStatementBuilder<K> existSetter, @Nonnull JdbcStatementBuilder<V> insertSetter, @Nonnull JdbcStatementBuilder<V> updateSetter, @Nonnull Function<R, K> keyExtractor, @Nonnull Function<R, V> valueExtractor) {
        this.existSQL = (String)Preconditions.checkNotNull((Object)existSQL);
        this.insertSQL = (String)Preconditions.checkNotNull((Object)insertSQL);
        this.updateSQL = (String)Preconditions.checkNotNull((Object)updateSQL);
        this.existSetter = (JdbcStatementBuilder)Preconditions.checkNotNull(existSetter);
        this.insertSetter = (JdbcStatementBuilder)Preconditions.checkNotNull(insertSetter);
        this.updateSetter = (JdbcStatementBuilder)Preconditions.checkNotNull(updateSetter);
        this.keyExtractor = (Function)Preconditions.checkNotNull(keyExtractor);
        this.valueMapper = (Function)Preconditions.checkNotNull(valueExtractor);
        this.batch = new HashMap();
    }

    @Override
    public void prepareStatements(Connection connection) throws SQLException {
        this.existStatement = connection.prepareStatement(this.existSQL);
        this.insertStatement = connection.prepareStatement(this.insertSQL);
        this.updateStatement = connection.prepareStatement(this.updateSQL);
    }

    @Override
    public void addToBatch(R record) {
        this.batch.put(this.keyExtractor.apply(record), this.valueMapper.apply(record));
    }

    @Override
    public void executeBatch() throws SQLException {
        if (!this.batch.isEmpty()) {
            for (Map.Entry<K, V> entry : this.batch.entrySet()) {
                this.processOneRowInBatch(entry.getKey(), entry.getValue());
            }
            this.updateStatement.executeBatch();
            this.insertStatement.executeBatch();
            this.batch.clear();
        }
    }

    private void processOneRowInBatch(K pk, V row) throws SQLException {
        if (this.exist(pk)) {
            this.updateSetter.accept(this.updateStatement, row);
            this.updateStatement.addBatch();
        } else {
            this.insertSetter.accept(this.insertStatement, row);
            this.insertStatement.addBatch();
        }
    }

    private boolean exist(K pk) throws SQLException {
        this.existSetter.accept(this.existStatement, pk);
        try (ResultSet resultSet = this.existStatement.executeQuery();){
            boolean bl = resultSet.next();
            return bl;
        }
    }

    @Override
    public void closeStatements() throws SQLException {
        for (PreparedStatement s : Arrays.asList(this.existStatement, this.insertStatement, this.updateStatement)) {
            if (s == null) continue;
            s.close();
        }
    }
}

