/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.Config;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.ConfigValue;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import io.debezium.config.Configuration;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RelationalBaseSourceConnector
extends SourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelationalBaseSourceConnector.class);

    @Override
    public Config validate(Map<String, String> connectorConfigs) {
        Configuration config = Configuration.from(connectorConfigs);
        Map<String, ConfigValue> results = this.validateAllFields(config);
        ConfigValue logicalName = results.get(RelationalDatabaseConnectorConfig.SERVER_NAME.name());
        ConfigValue hostnameValue = results.get(RelationalDatabaseConnectorConfig.HOSTNAME.name());
        ConfigValue portValue = results.get(RelationalDatabaseConnectorConfig.PORT.name());
        ConfigValue userValue = results.get(RelationalDatabaseConnectorConfig.USER.name());
        ConfigValue passwordValue = results.get(RelationalDatabaseConnectorConfig.PASSWORD.name());
        String passwordStringValue = config.getString(RelationalDatabaseConnectorConfig.PASSWORD);
        if (Strings.isNullOrEmpty(passwordStringValue)) {
            LOGGER.debug("The connection password is empty");
        }
        if (logicalName.errorMessages().isEmpty() && hostnameValue.errorMessages().isEmpty() && portValue.errorMessages().isEmpty() && userValue.errorMessages().isEmpty() && passwordValue.errorMessages().isEmpty()) {
            this.validateConnection(results, config);
        }
        return new Config(new ArrayList<ConfigValue>(results.values()));
    }

    protected abstract void validateConnection(Map<String, ConfigValue> var1, Configuration var2);

    protected abstract Map<String, ConfigValue> validateAllFields(Configuration var1);
}

