/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.utils;

import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import com.ververica.connectors.mysql.table.MySqlOptions;
import java.sql.Connection;
import java.sql.Statement;
import java.time.Duration;
import java.util.Properties;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.databases.mysql.dialect.MySqlDialect;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.connector.jdbc.internal.options.JdbcDmlOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlUtils.class);
    private static final String BASE_URL = "jdbc:mysql://%s:%s/%s";
    private static final MySqlDialect dialect = new MySqlDialect();

    public static String getDbUrl(String hostName, Integer port, String databaseName) {
        return String.format(BASE_URL, hostName, port, databaseName);
    }

    public static InternalJdbcConnectionOptions getJdbcOptions(ReadableConfig readableConfig) {
        return MySqlUtils.getJdbcOptions(readableConfig, new Properties());
    }

    public static InternalJdbcConnectionOptions getJdbcOptions(ReadableConfig readableConfig, Properties jdbcProperties) {
        String url;
        String string = url = readableConfig.getOptional(MySqlOptions.URL).isPresent() ? (String)readableConfig.get(MySqlOptions.URL) : MySqlUtils.getDbUrl((String)readableConfig.get(MySqlSourceOptions.HOSTNAME), (Integer)readableConfig.get(MySqlSourceOptions.PORT), (String)readableConfig.get(MySqlSourceOptions.DATABASE_NAME));
        if (!Boolean.parseBoolean(jdbcProperties.getProperty("tinyInt1isBit", "true"))) {
            url = url.contains("?") ? String.format("%s&tinyInt1isBit=false", url) : String.format("%s?tinyInt1isBit=false", url);
        }
        return InternalJdbcConnectionOptions.builder().setDBUrl(url).setTableName((String)readableConfig.get(MySqlSourceOptions.TABLE_NAME)).setDialect(new MySqlDialect()).setUsername((String)readableConfig.get(MySqlSourceOptions.USERNAME)).setPassword((String)readableConfig.get(MySqlSourceOptions.PASSWORD)).build();
    }

    public static DataSourceOptions getDataSourceOptions(ReadableConfig config) {
        return DataSourceOptions.builder().withConnectionMaxSize((Integer)config.get(MySqlSourceOptions.CONNECTION_POOL_SIZE)).withConnectionMinIdle((Integer)config.get(MySqlOptions.CONNECTION_MIN_IDLE)).withConnectionTimeout(((Duration)config.get(MySqlSourceOptions.CONNECT_TIMEOUT)).toMillis()).build();
    }

    public static JdbcDmlOptions getJdbcDmlOptions(InternalJdbcConnectionOptions jdbcOptions, ResolvedSchema schema) {
        String[] keyFields = schema.getPrimaryKey().map(pk -> pk.getColumns().toArray(new String[0])).orElse(null);
        return JdbcDmlOptions.builder().withTableName(jdbcOptions.getTableName()).withDialect(jdbcOptions.getDialect()).withFieldNames(schema.getColumnNames().toArray(new String[0])).withKeyFields(keyFields).build();
    }

    public static void closeMysqlConnection(Connection x) {
        if (x != null) {
            try {
                if (x.isClosed()) {
                    return;
                }
                x.close();
            }
            catch (Exception var2) {
                LOG.debug("close connection error", var2);
            }
        }
    }

    public static void closeMysqlStatement(Statement x) {
        if (x != null) {
            try {
                x.close();
            }
            catch (Exception var2) {
                LOG.debug("close statement error", var2);
            }
        }
    }
}

