/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table.sink;

import com.alibaba.ververica.connectors.common.errorcode.ConnectorErrors;
import com.alibaba.ververica.connectors.common.exception.ErrorUtils;
import com.alibaba.ververica.connectors.common.sink.OutputFormatSinkFunction;
import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import com.ververica.connectors.mysql.table.sink.MySqlOutputFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkFunctionProvider;
import org.apache.flink.types.RowKind;

public class MySqlTableSink
implements DynamicTableSink {
    private final InternalJdbcConnectionOptions jdbcOptions;
    private final DataSourceOptions dataSourceOptions;
    private final TableSchema tableSchema;
    private final int maxRetryTimes;
    private final int bufferSize;
    private final int batchSize;
    private final long flushIntervalMs;
    private final boolean ignoreDelete;
    private final String excludeUpdateColumnsStr;
    private final long maxSinkTps;
    private final DirtyDataStrategy dirtyDataStrategy;
    private final boolean isCreateTable;
    private final int varcharMaxLength;

    public MySqlTableSink(InternalJdbcConnectionOptions jdbcOptions, DataSourceOptions dataSourceOptions, TableSchema tableSchema, int maxRetryTimes, int bufferSize, int batchSize, long flushIntervalMs, boolean ignoreDelete, String excludeUpdateColumnsStr, long maxSinkTps, DirtyDataStrategy dirtyDataStrategy, boolean isCreateTable, int varcharMaxLength) {
        this.jdbcOptions = jdbcOptions;
        this.dataSourceOptions = dataSourceOptions;
        this.tableSchema = tableSchema;
        this.maxRetryTimes = maxRetryTimes;
        this.bufferSize = bufferSize;
        this.batchSize = batchSize;
        this.flushIntervalMs = flushIntervalMs;
        this.ignoreDelete = ignoreDelete;
        this.excludeUpdateColumnsStr = excludeUpdateColumnsStr;
        this.maxSinkTps = maxSinkTps;
        this.dirtyDataStrategy = dirtyDataStrategy;
        this.isCreateTable = isCreateTable;
        this.varcharMaxLength = varcharMaxLength;
    }

    public ChangelogMode getChangelogMode(ChangelogMode changelogMode) {
        return ChangelogMode.newBuilder().addContainedKind(RowKind.INSERT).addContainedKind(RowKind.DELETE).addContainedKind(RowKind.UPDATE_AFTER).build();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        if (!this.jdbcOptions.getDbURL().startsWith("jdbc:mysql://")) {
            throw new IllegalArgumentException(String.format("url of %s must starts with jdbc:mysql:// format, but actual url is %s", "MySQL", this.jdbcOptions.getDbURL()));
        }
        ArrayList<String> excludeUpdateColumns = new ArrayList<String>();
        if (!this.excludeUpdateColumnsStr.isEmpty()) {
            excludeUpdateColumns.addAll(Arrays.asList(this.excludeUpdateColumnsStr.split(",")));
        }
        MySqlOutputFormat mySqlOutputFormat = new MySqlOutputFormat(this.tableSchema, this.maxRetryTimes, this.dirtyDataStrategy, this.batchSize, this.bufferSize, this.flushIntervalMs, excludeUpdateColumns, this.maxSinkTps, this.ignoreDelete, this.dataSourceOptions, this.jdbcOptions);
        if (this.isCreateTable) {
            try {
                mySqlOutputFormat.createTable(this.varcharMaxLength);
            }
            catch (Exception exception) {
                throw ErrorUtils.getException(ConnectorErrors.INST.rdsCreateTableError("MySql"), exception);
            }
        }
        return SinkFunctionProvider.of(new OutputFormatSinkFunction(mySqlOutputFormat));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlTableSink)) {
            return false;
        }
        MySqlTableSink that = (MySqlTableSink)o;
        return this.maxRetryTimes == that.maxRetryTimes && this.bufferSize == that.bufferSize && this.batchSize == that.batchSize && this.flushIntervalMs == that.flushIntervalMs && this.ignoreDelete == that.ignoreDelete && this.maxSinkTps == that.maxSinkTps && this.isCreateTable == that.isCreateTable && this.varcharMaxLength == that.varcharMaxLength && Objects.equals(this.jdbcOptions, that.jdbcOptions) && Objects.equals(this.dataSourceOptions, that.dataSourceOptions) && Objects.equals(this.tableSchema, that.tableSchema) && Objects.equals(this.excludeUpdateColumnsStr, that.excludeUpdateColumnsStr) && this.dirtyDataStrategy == that.dirtyDataStrategy;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jdbcOptions, this.dataSourceOptions, this.tableSchema, this.maxRetryTimes, this.bufferSize, this.batchSize, this.flushIntervalMs, this.ignoreDelete, this.excludeUpdateColumnsStr, this.maxSinkTps, this.dirtyDataStrategy, this.isCreateTable, this.varcharMaxLength});
    }

    public DynamicTableSink copy() {
        return new MySqlTableSink(this.jdbcOptions, this.dataSourceOptions, this.tableSchema, this.maxRetryTimes, this.bufferSize, this.batchSize, this.flushIntervalMs, this.ignoreDelete, this.excludeUpdateColumnsStr, this.maxSinkTps, this.dirtyDataStrategy, this.isCreateTable, this.varcharMaxLength);
    }

    public String asSummaryString() {
        return "MySQL";
    }
}

