/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table;

import com.alibaba.ververica.connectors.common.dim.LookupFunctionWrapper;
import com.alibaba.ververica.connectors.common.dim.cache.CacheConfig;
import com.alibaba.ververica.connectors.common.dim.reload.CacheAllReloadConf;
import com.ververica.cdc.connectors.mysql.table.MySqlTableSource;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import com.ververica.connectors.mysql.table.dim.MySqlAllCacheRowFetcher;
import com.ververica.connectors.mysql.table.dim.MySqlRowFetcher;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.connector.source.TableFunctionProvider;
import org.apache.flink.table.connector.source.abilities.SupportsReadingMetadata;
import org.apache.flink.table.connector.source.abilities.SupportsSchemaEvolutionReading;
import org.apache.flink.table.connector.source.abilities.SupportsTableSourceMerge;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

public class MySqlDynamicTableSource
implements ScanTableSource,
LookupTableSource,
SupportsReadingMetadata,
SupportsSchemaEvolutionReading,
SupportsTableSourceMerge {
    private final MySqlTableSource cdcSource;
    private final ResolvedSchema physicalSchema;
    private final InternalJdbcConnectionOptions jdbcOptions;
    private final CacheConfig cacheConfig;
    private final DataSourceOptions dataSourceOptions;
    private final boolean isShardingTable;
    private final int maxRetryTimes;
    private final int maxFetchRows;

    public MySqlDynamicTableSource(MySqlTableSource cdcSource, ResolvedSchema physicalSchema, CacheConfig cacheConfig, InternalJdbcConnectionOptions jdbcOptions, DataSourceOptions dataSourceOptions, boolean isShardingTable, int maxRetryTimes, int maxFetchRows) {
        this.cdcSource = cdcSource;
        this.physicalSchema = physicalSchema;
        this.cacheConfig = cacheConfig;
        this.jdbcOptions = jdbcOptions;
        this.dataSourceOptions = dataSourceOptions;
        this.isShardingTable = isShardingTable;
        this.maxRetryTimes = maxRetryTimes;
        this.maxFetchRows = maxFetchRows;
    }

    public LookupTableSource.LookupRuntimeProvider getLookupRuntimeProvider(LookupTableSource.LookupContext context) {
        if (this.isShardingTable) {
            throw new UnsupportedOperationException("The specified table in Flink is sharding tables in the external database. It only supports to scan the sharding table in Flink now.");
        }
        String[] keyNames = new String[context.getKeys().length];
        for (int i = 0; i < keyNames.length; ++i) {
            int[] innerKeyArr = context.getKeys()[i];
            Preconditions.checkArgument((innerKeyArr.length == 1 ? 1 : 0) != 0, (Object)"MySQL only support non-nested look up keys");
            keyNames[i] = (String)this.physicalSchema.getColumnNames().get(innerKeyArr[0]);
        }
        if (this.cacheConfig.getCacheStrategy().isAllCache()) {
            Preconditions.checkState((this.cacheConfig.getCacheStrategy().getTtlMs() > 0L ? 1 : 0) != 0);
            CacheAllReloadConf reloadConf = new CacheAllReloadConf(this.cacheConfig.getTimeRangeBlacklist(), this.cacheConfig.getCacheScanLimit(), this.cacheConfig.getCacheStrategy().getTtlMs());
            return TableFunctionProvider.of((TableFunction)new LookupFunctionWrapper(new MySqlAllCacheRowFetcher(this.jdbcOptions, this.physicalSchema, keyNames, reloadConf, this.maxRetryTimes, this.maxFetchRows, this.dataSourceOptions)));
        }
        return TableFunctionProvider.of((TableFunction)new LookupFunctionWrapper(new MySqlRowFetcher(this.jdbcOptions.getTableName(), this.physicalSchema, keyNames, this.cacheConfig.getCacheStrategy(), this.maxRetryTimes, this.maxFetchRows, this.dataSourceOptions, this.jdbcOptions)));
    }

    public ChangelogMode getChangelogMode() {
        return this.getCdcTableSource().getChangelogMode();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        return this.getCdcTableSource().getScanRuntimeProvider(scanContext);
    }

    public DynamicTableSource copy() {
        return new MySqlDynamicTableSource((MySqlTableSource)this.cdcSource.copy(), this.physicalSchema, this.cacheConfig, this.jdbcOptions, this.dataSourceOptions, this.isShardingTable, this.maxRetryTimes, this.maxFetchRows);
    }

    public String asSummaryString() {
        return "MySQL";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlDynamicTableSource)) {
            return false;
        }
        MySqlDynamicTableSource that = (MySqlDynamicTableSource)o;
        return this.isShardingTable == that.isShardingTable && this.maxRetryTimes == that.maxRetryTimes && this.maxFetchRows == that.maxFetchRows && Objects.equals(this.cdcSource, that.cdcSource) && Objects.equals(this.physicalSchema, that.physicalSchema) && Objects.equals(this.jdbcOptions, that.jdbcOptions) && Objects.equals(this.dataSourceOptions, that.dataSourceOptions) && this.cacheConfig.getCacheScanLimit() == that.cacheConfig.getCacheScanLimit() && Objects.equals(this.cacheConfig.getCacheStrategy(), that.cacheConfig.getCacheStrategy()) && Objects.equals(this.cacheConfig.getTimeRangeBlacklist(), that.cacheConfig.getTimeRangeBlacklist());
    }

    public int hashCode() {
        return Objects.hash(this.cdcSource, this.physicalSchema, this.jdbcOptions, this.dataSourceOptions, this.isShardingTable, this.maxRetryTimes, this.maxFetchRows, this.cacheConfig.getCacheScanLimit(), this.cacheConfig.getTimeRangeBlacklist(), this.cacheConfig.getCacheStrategy());
    }

    public void applySchemaEvolution() {
        this.getCdcTableSource().applySchemaEvolution();
    }

    public boolean applyTableSource(ScanTableSource anotherScanTableSource) {
        if (anotherScanTableSource instanceof MySqlDynamicTableSource) {
            return this.getCdcTableSource().applyTableSource(((MySqlDynamicTableSource)anotherScanTableSource).getCdcTableSource());
        }
        if (anotherScanTableSource instanceof MySqlTableSource) {
            throw new IllegalArgumentException("MySqlDynamicTableSource is not allowed to be merged with MySqlTableSource currently.");
        }
        return false;
    }

    public Map<String, DataType> listReadableMetadata() {
        return this.getCdcTableSource().listReadableMetadata();
    }

    public void applyReadableMetadata(List<String> list, DataType dataType) {
        this.getCdcTableSource().applyReadableMetadata(list, dataType);
    }

    @VisibleForTesting
    public MySqlTableSource getCdcTableSource() {
        return this.cdcSource;
    }
}

