/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.connectors.mysql.table;

import com.alibaba.ververica.connectors.common.source.resolver.DirtyDataStrategy;
import com.alibaba.ververica.connectors.common.util.ContextUtil;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.table.MySqlTableSource;
import com.ververica.cdc.connectors.mysql.table.MySqlTableSourceFactory;
import com.ververica.cdc.debezium.utils.JdbcUrlUtils;
import com.ververica.cdc.debezium.utils.ResolvedSchemaUtils;
import com.ververica.connectors.mysql.table.DataSourceOptions;
import com.ververica.connectors.mysql.table.MySqlDynamicTableSource;
import com.ververica.connectors.mysql.table.MySqlOptions;
import com.ververica.connectors.mysql.table.sink.MySqlTableSink;
import com.ververica.connectors.mysql.utils.MySqlUtils;
import java.time.Duration;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.jdbc.internal.options.InternalJdbcConnectionOptions;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSinkFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.util.Preconditions;

public class MySqlDynamicTableFactory
extends MySqlTableSourceFactory
implements DynamicTableSinkFactory {
    @VisibleForTesting
    public static final String SHARDING_TABLE_EXCEPTION_MESSAGE = "The specified table in Flink is sharding tables in the external database. It only supports to scan the sharding table in Flink now.";
    private static final String IDENTIFIER = "mysql";

    public DynamicTableSink createDynamicTableSink(DynamicTableFactory.Context context) {
        DynamicTableFactory.Context normalizedContext = ContextUtil.normalizeContext((DynamicTableFactory)this, context);
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)normalizedContext);
        ReadableConfig config = helper.getOptions();
        if (((Boolean)config.get(MySqlSourceOptions.INTERNAL_IS_SHARDING_TABLE)).booleanValue()) {
            throw new UnsupportedOperationException(SHARDING_TABLE_EXCEPTION_MESSAGE);
        }
        helper.validateExcept(new String[]{"jdbc.properties."});
        MySqlOptions.validateConfigOptions(config);
        TableSchema physicalSchema = TableSchemaUtils.getPhysicalSchema((TableSchema)normalizedContext.getCatalogTable().getSchema());
        InternalJdbcConnectionOptions jdbcOptions = MySqlUtils.getJdbcOptions(config);
        DataSourceOptions dataSourceOptions = MySqlUtils.getDataSourceOptions(config);
        int sinkMaxRetryTimes = (Integer)config.get(MySqlOptions.SINK_MAX_RETRIES);
        int sinkBufferSize = (Integer)config.get(MySqlOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        int sinkBatchSize = (Integer)config.get(MySqlOptions.SINK_BATCH_SIZE);
        long sinkFlushIntervalMs = ((Duration)config.get(MySqlOptions.SINK_BUFFER_FLUSH_INTERVAL)).toMillis();
        boolean sinkIgnoreDelete = (Boolean)config.get(MySqlOptions.SINK_IGNORE_DELETE);
        String sinkExcludeUpdateColumnsStr = (String)config.get(MySqlOptions.SINK_EXCLUDE_UPDATE_FIELDS);
        long maxSinkTps = (Long)config.get(MySqlOptions.SINK_MAX_SINK_TPS);
        DirtyDataStrategy sinkDirtyDataStrategy = (DirtyDataStrategy)((Object)config.get(MySqlOptions.SINK_ACTION_ON_INSERT_ERROR));
        boolean isCreateTable = (Boolean)config.get(MySqlOptions.SINK_CREATE_TABLE_IF_NOT_EXISTS);
        int sinkVarcharMaxLength = (Integer)config.get(MySqlOptions.SINK_VARCHAR_MAX_LENGTH);
        return new MySqlTableSink(jdbcOptions, dataSourceOptions, physicalSchema, sinkMaxRetryTimes, sinkBufferSize, sinkBatchSize, sinkFlushIntervalMs, sinkIgnoreDelete, sinkExcludeUpdateColumnsStr, maxSinkTps, sinkDirtyDataStrategy, isCreateTable, sinkVarcharMaxLength);
    }

    @Override
    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validateExcept(new String[]{"debezium.", "__internal", "jdbc.properties."});
        ReadableConfig config = helper.getOptions();
        helper.validate();
        MySqlOptions.validateConfigOptions(config);
        ResolvedSchema physicalSchema = ResolvedSchemaUtils.getPhysicalSchema(context.getCatalogTable().getResolvedSchema());
        InternalJdbcConnectionOptions jdbcOptions = MySqlUtils.getJdbcOptions(config, JdbcUrlUtils.getJdbcProperties(context.getCatalogTable().getOptions()));
        DataSourceOptions dataSourceOptions = MySqlUtils.getDataSourceOptions(config);
        this.validateAndChangeOptionsForCdcTable(config, context, physicalSchema);
        MySqlTableSource cdcSource = (MySqlTableSource)super.createDynamicTableSource(context);
        return new MySqlDynamicTableSource(cdcSource, physicalSchema, MySqlOptions.createCacheConfig(config), jdbcOptions, dataSourceOptions, (Boolean)config.get(MySqlSourceOptions.INTERNAL_IS_SHARDING_TABLE), (Integer)config.get(MySqlOptions.LOOKUP_MAX_RETRIES), (Integer)config.get(MySqlOptions.LOOKUP_JOIN_MAX_ROWS));
    }

    @Override
    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        Set<ConfigOption<?>> cdcRequiredOptions = super.requiredOptions();
        cdcRequiredOptions.remove(MySqlSourceOptions.HOSTNAME);
        cdcRequiredOptions.remove(MySqlSourceOptions.DATABASE_NAME);
        return cdcRequiredOptions;
    }

    @Override
    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet(super.optionalOptions());
        options.add(MySqlSourceOptions.HOSTNAME);
        options.add(MySqlSourceOptions.DATABASE_NAME);
        options.add(MySqlOptions.URL);
        options.add(MySqlOptions.CONNECTION_MIN_IDLE);
        options.add(MySqlOptions.SINK_BUFFER_FLUSH_MAX_ROWS);
        options.add(MySqlOptions.SINK_BUFFER_FLUSH_INTERVAL);
        options.add(MySqlOptions.SINK_MAX_RETRIES);
        options.add(MySqlOptions.SINK_BATCH_SIZE);
        options.add(MySqlOptions.SINK_EXCLUDE_UPDATE_FIELDS);
        options.add(MySqlOptions.SINK_IGNORE_DELETE);
        options.add(MySqlOptions.SINK_CREATE_TABLE_IF_NOT_EXISTS);
        options.add(MySqlOptions.SINK_VARCHAR_MAX_LENGTH);
        options.add(MySqlOptions.SINK_MAX_SINK_TPS);
        options.add(MySqlOptions.SINK_ACTION_ON_INSERT_ERROR);
        options.add(MySqlOptions.LOOKUP_CACHE_STRATEGY);
        options.add(MySqlOptions.LOOKUP_CACHE_MAX_ROWS);
        options.add(MySqlOptions.LOOKUP_CACHE_TTL);
        options.add(MySqlOptions.LOOKUP_MAX_RETRIES);
        options.add(MySqlOptions.LOOKUP_JOIN_MAX_ROWS);
        options.add(MySqlOptions.LOOKUP_CACHE_EMPTY);
        options.add(MySqlOptions.LOOKUP_CACHE_RELOAD_TIME_BLACKLIST);
        options.add(MySqlOptions.LOOKUP_CACHE_SCAN_LIMIT);
        return options;
    }

    private void validateAndChangeOptionsForCdcTable(ReadableConfig config, DynamicTableFactory.Context context, ResolvedSchema physicalSchema) {
        Optional urlOptional = config.getOptional(MySqlOptions.URL);
        Optional hostnameOptional = config.getOptional(MySqlSourceOptions.HOSTNAME);
        Optional databaseNameOptional = config.getOptional(MySqlSourceOptions.DATABASE_NAME);
        if (!urlOptional.isPresent()) {
            Preconditions.checkState((hostnameOptional.isPresent() && databaseNameOptional.isPresent() ? 1 : 0) != 0, (Object)String.format("The options '%s' and '%s' must be set when the option '%s' is not.", MySqlSourceOptions.HOSTNAME.key(), MySqlSourceOptions.DATABASE_NAME.key(), MySqlOptions.URL.key()));
            return;
        }
        String[] result = MySqlOptions.parseMysqlJdbcUrl((String)urlOptional.get());
        if (hostnameOptional.isPresent()) {
            Preconditions.checkState((boolean)((String)hostnameOptional.get()).equals(result[0]), (Object)String.format("The options %s is set to '%s'. It is different from '%s' parsed from url.", MySqlSourceOptions.HOSTNAME.key(), hostnameOptional.get(), result[0]));
        } else {
            context.getCatalogTable().getOptions().put(MySqlSourceOptions.HOSTNAME.key(), result[0]);
        }
        if (databaseNameOptional.isPresent()) {
            Preconditions.checkState((boolean)((String)databaseNameOptional.get()).equals(result[2]), (Object)String.format("The options %s is set to '%s'. It is different from '%s' parsed from url.", MySqlSourceOptions.DATABASE_NAME.key(), databaseNameOptional.get(), result[2]));
        } else {
            context.getCatalogTable().getOptions().put(MySqlSourceOptions.DATABASE_NAME.key(), result[2]);
        }
        Preconditions.checkState((boolean)String.valueOf(config.get(MySqlSourceOptions.PORT)).equals(result[1]), (Object)String.format("The options %s is set to '%d'. It is different from the port '%s' parsed from url.", MySqlSourceOptions.PORT.key(), config.get(MySqlSourceOptions.PORT), result[1]));
    }
}

