/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.debezium.table;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.table.MetadataConverter;
import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.util.Collector;

@Internal
public class AppendMetadataCollector
implements Collector<RowData>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MetadataConverter[] metadataConverters;
    public transient SourceRecord inputRecord;
    public transient Collector<RowData> outputCollector;

    public AppendMetadataCollector(MetadataConverter[] metadataConverters) {
        this.metadataConverters = metadataConverters;
    }

    public void collect(RowData physicalRow) {
        RowData outRow = physicalRow;
        if (this.metadataConverters.length > 0) {
            outRow = new JoinedRowData(physicalRow.getRowKind(), outRow, this.extractData(this.metadataConverters));
        }
        this.outputCollector.collect((Object)outRow);
    }

    protected RowData extractData(MetadataConverter[] converters) {
        GenericRowData extraColumns = new GenericRowData(converters.length);
        for (int i = 0; i < converters.length; ++i) {
            Object meta = converters[i].read(this.inputRecord);
            extraColumns.setField(i, meta);
        }
        return extraColumns;
    }

    public void close() {
    }
}

