/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.config.provider.ConfigProvider;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.rest.ConnectRestExtension;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.PluginDesc;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.sink.SinkConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceConnector;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.Converter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.HeaderConverter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.Transformation;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.transforms.predicates.Predicate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PluginScanResult {
    private final Collection<PluginDesc<SinkConnector>> sinkConnectors;
    private final Collection<PluginDesc<SourceConnector>> sourceConnectors;
    private final Collection<PluginDesc<Converter>> converters;
    private final Collection<PluginDesc<HeaderConverter>> headerConverters;
    private final Collection<PluginDesc<Transformation<?>>> transformations;
    private final Collection<PluginDesc<Predicate<?>>> predicates;
    private final Collection<PluginDesc<ConfigProvider>> configProviders;
    private final Collection<PluginDesc<ConnectRestExtension>> restExtensions;
    private final Collection<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies;
    private final List<Collection<?>> allPlugins;

    public PluginScanResult(Collection<PluginDesc<SinkConnector>> sinkConnectors, Collection<PluginDesc<SourceConnector>> sourceConnectors, Collection<PluginDesc<Converter>> converters, Collection<PluginDesc<HeaderConverter>> headerConverters, Collection<PluginDesc<Transformation<?>>> transformations, Collection<PluginDesc<Predicate<?>>> predicates, Collection<PluginDesc<ConfigProvider>> configProviders, Collection<PluginDesc<ConnectRestExtension>> restExtensions, Collection<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies) {
        this.sinkConnectors = sinkConnectors;
        this.sourceConnectors = sourceConnectors;
        this.converters = converters;
        this.headerConverters = headerConverters;
        this.transformations = transformations;
        this.predicates = predicates;
        this.configProviders = configProviders;
        this.restExtensions = restExtensions;
        this.connectorClientConfigPolicies = connectorClientConfigPolicies;
        this.allPlugins = Arrays.asList(sinkConnectors, sourceConnectors, converters, headerConverters, transformations, configProviders, connectorClientConfigPolicies);
    }

    public Collection<PluginDesc<SinkConnector>> sinkConnectors() {
        return this.sinkConnectors;
    }

    public Collection<PluginDesc<SourceConnector>> sourceConnectors() {
        return this.sourceConnectors;
    }

    public Collection<PluginDesc<Converter>> converters() {
        return this.converters;
    }

    public Collection<PluginDesc<HeaderConverter>> headerConverters() {
        return this.headerConverters;
    }

    public Collection<PluginDesc<Transformation<?>>> transformations() {
        return this.transformations;
    }

    public Collection<PluginDesc<Predicate<?>>> predicates() {
        return this.predicates;
    }

    public Collection<PluginDesc<ConfigProvider>> configProviders() {
        return this.configProviders;
    }

    public Collection<PluginDesc<ConnectRestExtension>> restExtensions() {
        return this.restExtensions;
    }

    public Collection<PluginDesc<ConnectorClientConfigOverridePolicy>> connectorClientConfigPolicies() {
        return this.connectorClientConfigPolicies;
    }

    public boolean isEmpty() {
        boolean isEmpty = true;
        for (Collection<?> plugins : this.allPlugins) {
            isEmpty = isEmpty && plugins.isEmpty();
        }
        return isEmpty;
    }
}

