/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.cli;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Exit;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Time;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.utils.Utils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Connect;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.Worker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerConfigTransformer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.WorkerInfo;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.distributed.DistributedHerder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.isolation.Plugins;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.runtime.rest.RestServer;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.ConfigBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.Converter;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.KafkaConfigBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.KafkaOffsetBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.KafkaStatusBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.storage.StatusBackingStore;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.ConnectUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.util.SharedTopicAdmin;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectDistributed {
    private static final Logger log = LoggerFactory.getLogger(ConnectDistributed.class);
    private final Time time = Time.SYSTEM;
    private final long initStart = this.time.hiResClockMs();

    public static void main(String[] args) {
        if (args.length < 1 || Arrays.asList(args).contains("--help")) {
            log.info("Usage: ConnectDistributed worker.properties");
            Exit.exit(1);
        }
        try {
            WorkerInfo initInfo = new WorkerInfo();
            initInfo.logAll();
            String workerPropsFile = args[0];
            Map<String, String> workerProps = !workerPropsFile.isEmpty() ? Utils.propsToStringMap(Utils.loadProps(workerPropsFile)) : Collections.emptyMap();
            ConnectDistributed connectDistributed = new ConnectDistributed();
            Connect connect = connectDistributed.startConnect(workerProps);
            connect.awaitStop();
        }
        catch (Throwable t) {
            log.error("Stopping due to error", t);
            Exit.exit(2);
        }
    }

    public Connect startConnect(Map<String, String> workerProps) {
        log.info("Scanning for plugin classes. This might take a moment ...");
        Plugins plugins = new Plugins(workerProps);
        plugins.compareAndSwapWithDelegatingLoader();
        DistributedConfig config = new DistributedConfig(workerProps);
        String kafkaClusterId = ConnectUtils.lookupKafkaClusterId(config);
        log.debug("Kafka cluster ID: {}", (Object)kafkaClusterId);
        RestServer rest = new RestServer(config);
        rest.initializeServer();
        URI advertisedUrl = rest.advertisedUrl();
        String workerId = advertisedUrl.getHost() + ":" + advertisedUrl.getPort();
        HashMap<String, Object> adminProps = new HashMap<String, Object>(config.originals());
        ConnectUtils.addMetricsContextProperties(adminProps, config, kafkaClusterId);
        SharedTopicAdmin sharedAdmin = new SharedTopicAdmin(adminProps);
        KafkaOffsetBackingStore offsetBackingStore = new KafkaOffsetBackingStore(sharedAdmin);
        offsetBackingStore.configure(config);
        ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy = plugins.newPlugin(config.getString("connector.client.config.override.policy"), config, ConnectorClientConfigOverridePolicy.class);
        Worker worker = new Worker(workerId, this.time, plugins, config, offsetBackingStore, connectorClientConfigOverridePolicy);
        WorkerConfigTransformer configTransformer = worker.configTransformer();
        Converter internalValueConverter = worker.getInternalValueConverter();
        KafkaStatusBackingStore statusBackingStore = new KafkaStatusBackingStore(this.time, internalValueConverter, sharedAdmin);
        statusBackingStore.configure(config);
        KafkaConfigBackingStore configBackingStore = new KafkaConfigBackingStore(internalValueConverter, config, configTransformer, sharedAdmin);
        DistributedHerder herder = new DistributedHerder(config, this.time, worker, kafkaClusterId, (StatusBackingStore)statusBackingStore, (ConfigBackingStore)configBackingStore, advertisedUrl.toString(), connectorClientConfigOverridePolicy, sharedAdmin);
        Connect connect = new Connect(herder, rest);
        log.info("Kafka Connect distributed worker initialization took {}ms", (Object)(this.time.hiResClockMs() - this.initStart));
        try {
            connect.start();
        }
        catch (Exception e) {
            log.error("Failed to start Connect", e);
            connect.stop();
            Exit.exit(3);
        }
        return connect;
    }
}

