/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.reader;

import com.ververica.cdc.connectors.mysql.source.MySqlEvolvingSourceDeserializeSchema;
import com.ververica.cdc.connectors.mysql.source.metrics.MySqlSourceReaderMetrics;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplitState;
import com.ververica.cdc.connectors.mysql.source.split.SourceRecords;
import com.ververica.cdc.connectors.mysql.source.utils.RecordUtils;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.source.SourceRecord;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import com.ververica.cdc.debezium.history.FlinkJsonTableChangeSerializer;
import io.debezium.document.Array;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.TableChanges;
import java.util.Iterator;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.util.Collector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlRecordEmitter<T>
implements RecordEmitter<SourceRecords, T, MySqlSplitState> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlRecordEmitter.class);
    private static final FlinkJsonTableChangeSerializer TABLE_CHANGE_SERIALIZER = new FlinkJsonTableChangeSerializer();
    private final DebeziumDeserializationSchema<T> debeziumDeserializationSchema;
    private final MySqlSourceReaderMetrics sourceReaderMetrics;
    private final boolean includeSchemaChanges;
    private final OutputCollector<T> outputCollector;

    public MySqlRecordEmitter(DebeziumDeserializationSchema<T> debeziumDeserializationSchema, MySqlSourceReaderMetrics sourceReaderMetrics, boolean includeSchemaChanges) {
        this.debeziumDeserializationSchema = debeziumDeserializationSchema;
        this.sourceReaderMetrics = sourceReaderMetrics;
        this.includeSchemaChanges = includeSchemaChanges;
        this.outputCollector = new OutputCollector();
    }

    public void emitRecord(SourceRecords sourceRecords, SourceOutput<T> output, MySqlSplitState splitState) throws Exception {
        Iterator<SourceRecord> elementIterator = sourceRecords.iterator();
        while (elementIterator.hasNext()) {
            this.processElement(elementIterator.next(), output, splitState);
        }
    }

    private void processElement(SourceRecord element, SourceOutput<T> output, MySqlSplitState splitState) throws Exception {
        if (RecordUtils.isWatermarkEvent(element)) {
            BinlogOffset watermark = RecordUtils.getWatermark(element);
            if (RecordUtils.isHighWatermarkEvent(element) && splitState.isSnapshotSplitState()) {
                splitState.asSnapshotSplitState().setHighWatermark(watermark);
            }
        } else if (RecordUtils.isSchemaChangeEvent(element) && splitState.isBinlogSplitState()) {
            HistoryRecord historyRecord = RecordUtils.getHistoryRecord(element);
            Array tableChanges = historyRecord.document().getArray("tableChanges");
            TableChanges changes = TABLE_CHANGE_SERIALIZER.deserialize(tableChanges, true);
            for (TableChanges.TableChange tableChange : changes) {
                splitState.asBinlogSplitState().recordSchema(tableChange.getId(), tableChange);
                this.applyTableChange(tableChange);
            }
            if (this.includeSchemaChanges) {
                this.updateStartingOffsetForSplit(splitState, element);
                this.emitElement(element, output);
            }
        } else if (RecordUtils.isDataChangeRecord(element)) {
            this.updateStartingOffsetForSplit(splitState, element);
            this.emitElement(element, output);
        } else if (RecordUtils.isHeartbeatEvent(element)) {
            this.updateStartingOffsetForSplit(splitState, element);
        } else {
            LOG.info("Meet unknown element {}, just skip.", (Object)element);
        }
    }

    private void updateStartingOffsetForSplit(MySqlSplitState splitState, SourceRecord element) {
        if (splitState.isBinlogSplitState()) {
            BinlogOffset position = RecordUtils.getBinlogPosition(element);
            splitState.asBinlogSplitState().setStartingOffset(position);
        }
    }

    private void emitElement(SourceRecord element, SourceOutput<T> output) throws Exception {
        this.sourceReaderMetrics.markRecord(element);
        ((OutputCollector)this.outputCollector).output = output;
        ((OutputCollector)this.outputCollector).currentMessageTimestamp = RecordUtils.getMessageTimestamp(element);
        this.debeziumDeserializationSchema.deserialize(element, this.outputCollector);
    }

    public void applyTableChange(TableChanges.TableChange tableChange) {
        if (this.debeziumDeserializationSchema instanceof MySqlEvolvingSourceDeserializeSchema) {
            ((MySqlEvolvingSourceDeserializeSchema)this.debeziumDeserializationSchema).applyTableChange(tableChange);
        }
    }

    private static class OutputCollector<T>
    implements Collector<T> {
        private SourceOutput<T> output;
        private Long currentMessageTimestamp;

        private OutputCollector() {
        }

        public void collect(T record) {
            if (this.currentMessageTimestamp != null && this.currentMessageTimestamp > 0L) {
                this.output.collect(record, this.currentMessageTimestamp.longValue());
            } else {
                this.output.collect(record);
            }
        }

        public void close() {
        }
    }
}

