/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.config;

import com.ververica.cdc.connectors.mysql.debezium.EmbeddedFlinkDatabaseHistory;
import com.ververica.cdc.connectors.mysql.rds.config.AliyunRdsConfig;
import com.ververica.cdc.connectors.mysql.source.config.CapturingMode;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.source.config.ServerIdRange;
import com.ververica.cdc.connectors.mysql.source.utils.EnvironmentUtils;
import com.ververica.cdc.connectors.mysql.table.StartupMode;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import java.io.Serializable;
import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.util.Preconditions;

@Internal
public class MySqlSourceConfigFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int port = 3306;
    private String hostname;
    private String username;
    private String password;
    private ServerIdRange serverIdRange;
    private List<String> databaseList;
    private List<String> tableList;
    private String serverTimeZone = ZoneId.systemDefault().getId();
    private StartupOptions startupOptions = StartupOptions.initial();
    private int splitSize = (Integer)MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE.defaultValue();
    private int splitMetaGroupSize = (Integer)MySqlSourceOptions.CHUNK_META_GROUP_SIZE.defaultValue();
    private int fetchSize = (Integer)MySqlSourceOptions.SCAN_SNAPSHOT_FETCH_SIZE.defaultValue();
    private Duration connectTimeout = (Duration)MySqlSourceOptions.CONNECT_TIMEOUT.defaultValue();
    private int connectMaxRetries = (Integer)MySqlSourceOptions.CONNECT_MAX_RETRIES.defaultValue();
    private int connectionPoolSize = (Integer)MySqlSourceOptions.CONNECTION_POOL_SIZE.defaultValue();
    private double distributionFactorUpper = (Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_UPPER_BOUND.defaultValue();
    private double distributionFactorLower = (Double)MySqlSourceOptions.CHUNK_KEY_EVEN_DISTRIBUTION_FACTOR_LOWER_BOUND.defaultValue();
    private boolean includeSchemaChanges = false;
    private boolean scanNewlyAddedTableEnabled = false;
    private boolean closeIdleReaders = false;
    private Properties jdbcProperties;
    private Duration heartbeatInterval = (Duration)MySqlSourceOptions.HEARTBEAT_INTERVAL.defaultValue();
    private Properties dbzProperties;
    private Map<ObjectPath, String> chunkKeyColumns = new HashMap<ObjectPath, String>();
    private boolean skipSnapshotBackfill = false;
    private CapturingMode capturingMode;
    @Nullable
    private AliyunRdsConfig rdsConfig;

    public MySqlSourceConfigFactory hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    public MySqlSourceConfigFactory port(int port) {
        this.port = port;
        return this;
    }

    public MySqlSourceConfigFactory databaseList(String ... databaseList) {
        this.databaseList = Arrays.asList(databaseList);
        return this;
    }

    public MySqlSourceConfigFactory tableList(String ... tableList) {
        this.tableList = Arrays.asList(tableList);
        return this;
    }

    public MySqlSourceConfigFactory username(String username) {
        this.username = username;
        return this;
    }

    public MySqlSourceConfigFactory password(String password) {
        this.password = password;
        return this;
    }

    public MySqlSourceConfigFactory serverId(String serverId) {
        this.serverIdRange = ServerIdRange.from(serverId);
        return this;
    }

    public MySqlSourceConfigFactory serverTimeZone(String timeZone) {
        this.serverTimeZone = timeZone;
        return this;
    }

    public MySqlSourceConfigFactory chunkKeyColumn(ObjectPath objectPath, String chunkKeyColumn) {
        this.chunkKeyColumns.put(objectPath, chunkKeyColumn);
        return this;
    }

    public MySqlSourceConfigFactory chunkKeyColumn(Map<ObjectPath, String> chunkKeyColumns) {
        this.chunkKeyColumns.putAll(chunkKeyColumns);
        return this;
    }

    public MySqlSourceConfigFactory splitSize(int splitSize) {
        this.splitSize = splitSize;
        return this;
    }

    public MySqlSourceConfigFactory splitMetaGroupSize(int splitMetaGroupSize) {
        this.splitMetaGroupSize = splitMetaGroupSize;
        return this;
    }

    public MySqlSourceConfigFactory distributionFactorUpper(double distributionFactorUpper) {
        this.distributionFactorUpper = distributionFactorUpper;
        return this;
    }

    public MySqlSourceConfigFactory distributionFactorLower(double distributionFactorLower) {
        this.distributionFactorLower = distributionFactorLower;
        return this;
    }

    public MySqlSourceConfigFactory fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public MySqlSourceConfigFactory connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public MySqlSourceConfigFactory connectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
        return this;
    }

    public MySqlSourceConfigFactory connectMaxRetries(int connectMaxRetries) {
        this.connectMaxRetries = connectMaxRetries;
        return this;
    }

    public MySqlSourceConfigFactory includeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
        return this;
    }

    public MySqlSourceConfigFactory scanNewlyAddedTableEnabled(boolean scanNewlyAddedTableEnabled) {
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        return this;
    }

    public MySqlSourceConfigFactory jdbcProperties(Properties jdbcProperties) {
        this.jdbcProperties = jdbcProperties;
        return this;
    }

    public MySqlSourceConfigFactory startupOptions(StartupOptions startupOptions) {
        this.startupOptions = startupOptions;
        return this;
    }

    public MySqlSourceConfigFactory heartbeatInterval(Duration heartbeatInterval) {
        this.heartbeatInterval = heartbeatInterval;
        return this;
    }

    public MySqlSourceConfigFactory debeziumProperties(Properties properties) {
        this.dbzProperties = properties;
        return this;
    }

    public MySqlSourceConfigFactory skipSnapshotBackfill(boolean skipSnapshotBackfill) {
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        return this;
    }

    public MySqlSourceConfigFactory capturingMode(CapturingMode capturingMode) {
        this.capturingMode = capturingMode;
        return this;
    }

    public MySqlSourceConfigFactory enableReadingRdsArchivedBinlog(AliyunRdsConfig rdsConfig) {
        this.rdsConfig = rdsConfig;
        return this;
    }

    public MySqlSourceConfigFactory closeIdleReaders(boolean closeIdleReaders) {
        this.closeIdleReaders = closeIdleReaders;
        return this;
    }

    public MySqlSourceConfig createConfig(int subtaskId) {
        return this.createConfig(subtaskId, "mysql_binlog_source");
    }

    public MySqlSourceConfig createConfig(int subtaskId, String serverName) {
        EnvironmentUtils.checkSupportCheckpointsAfterTasksFinished(this.closeIdleReaders);
        Properties props = new Properties();
        props.setProperty("database.server.name", serverName);
        props.setProperty("database.hostname", (String)Preconditions.checkNotNull((Object)this.hostname));
        props.setProperty("database.user", (String)Preconditions.checkNotNull((Object)this.username));
        props.setProperty("database.password", (String)Preconditions.checkNotNull((Object)this.password));
        props.setProperty("database.port", String.valueOf(this.port));
        props.setProperty("database.fetchSize", String.valueOf(this.fetchSize));
        props.setProperty("database.responseBuffering", "adaptive");
        props.setProperty("database.serverTimezone", this.serverTimeZone);
        props.setProperty("database.history", EmbeddedFlinkDatabaseHistory.class.getCanonicalName());
        props.setProperty("database.history.instance.name", UUID.randomUUID().toString() + "_" + subtaskId);
        props.setProperty("database.history.skip.unparseable.ddl", String.valueOf(true));
        props.setProperty("database.history.refer.ddl", String.valueOf(true));
        props.setProperty("connect.timeout.ms", String.valueOf(this.connectTimeout.toMillis()));
        props.setProperty("include.schema.changes", String.valueOf(true));
        props.setProperty("offset.flush.interval.ms", String.valueOf(Long.MAX_VALUE));
        props.setProperty("tombstones.on.delete", String.valueOf(false));
        props.setProperty("heartbeat.interval.ms", String.valueOf(this.heartbeatInterval.toMillis()));
        props.put("bigint.unsigned.handling.mode", "precise");
        if (this.serverIdRange != null) {
            int serverId = this.serverIdRange.getServerId(subtaskId);
            props.setProperty("database.server.id", String.valueOf(serverId));
        }
        if (this.databaseList != null) {
            props.setProperty("database.include.list", String.join((CharSequence)",", this.databaseList));
        }
        if (this.tableList != null) {
            props.setProperty("table.include.list", String.join((CharSequence)",", this.tableList));
        }
        if (this.serverTimeZone != null) {
            props.setProperty("database.serverTimezone", this.serverTimeZone);
        }
        if (this.dbzProperties != null) {
            props.putAll((Map<?, ?>)this.dbzProperties);
        }
        if (this.jdbcProperties == null) {
            this.jdbcProperties = new Properties();
        }
        this.validateCapturingMode();
        return new MySqlSourceConfig(this.hostname, this.port, this.username, this.password, this.databaseList, this.tableList, this.serverIdRange, this.startupOptions, this.splitSize, this.splitMetaGroupSize, this.fetchSize, this.serverTimeZone, this.connectTimeout, this.connectMaxRetries, this.connectionPoolSize, this.distributionFactorUpper, this.distributionFactorLower, this.includeSchemaChanges, this.scanNewlyAddedTableEnabled, this.closeIdleReaders, props, this.jdbcProperties, this.chunkKeyColumns, this.skipSnapshotBackfill, this.capturingMode, this.rdsConfig);
    }

    private void validateCapturingMode() {
        if (this.capturingMode == null) {
            if (this.isBinlogOnlyStartupMode(this.startupOptions.startupMode)) {
                this.capturingMode = CapturingMode.BINLOG_ONLY;
            } else if (this.isHybridStartupMode(this.startupOptions.startupMode)) {
                this.capturingMode = CapturingMode.HYBRID;
            }
        } else {
            switch (this.capturingMode) {
                case BINLOG_ONLY: {
                    Preconditions.checkArgument((boolean)this.isBinlogOnlyStartupMode(this.startupOptions.startupMode), (String)"StartupMode must be set to %s, %s, %s or %s under capturing mode %s", (Object[])new Object[]{StartupMode.EARLIEST_OFFSET, StartupMode.LATEST_OFFSET, StartupMode.SPECIFIC_OFFSETS, StartupMode.TIMESTAMP, CapturingMode.BINLOG_ONLY});
                    break;
                }
                case HYBRID: {
                    Preconditions.checkArgument((boolean)this.isHybridStartupMode(this.startupOptions.startupMode), (String)"StartupMode must be set to %s under capturing mode %s", (Object[])new Object[]{StartupMode.INITIAL, CapturingMode.HYBRID});
                    break;
                }
                case SNAPSHOT_ONLY: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized capturing mode");
                }
            }
        }
    }

    private boolean isBinlogOnlyStartupMode(StartupMode startupMode) {
        return startupMode == StartupMode.EARLIEST_OFFSET || startupMode == StartupMode.LATEST_OFFSET || startupMode == StartupMode.SPECIFIC_OFFSETS || startupMode == StartupMode.TIMESTAMP;
    }

    private boolean isHybridStartupMode(StartupMode startupMode) {
        return startupMode == StartupMode.INITIAL;
    }
}

