/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.config;

import com.ververica.cdc.connectors.mysql.rds.config.AliyunRdsConfig;
import com.ververica.cdc.connectors.mysql.source.config.CapturingMode;
import com.ververica.cdc.connectors.mysql.source.config.ServerIdRange;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import io.debezium.config.Configuration;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.util.Preconditions;

public class MySqlSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String hostname;
    private final int port;
    private final String username;
    private final String password;
    private final List<String> databaseList;
    private final List<String> tableList;
    @Nullable
    private final ServerIdRange serverIdRange;
    private final StartupOptions startupOptions;
    private final int splitSize;
    private final int splitMetaGroupSize;
    private final int fetchSize;
    private final String serverTimeZone;
    private final Duration connectTimeout;
    private final int connectMaxRetries;
    private final int connectionPoolSize;
    private final double distributionFactorUpper;
    private final double distributionFactorLower;
    private final boolean includeSchemaChanges;
    private final boolean scanNewlyAddedTableEnabled;
    private final boolean closeIdleReaders;
    private final Properties jdbcProperties;
    private final boolean skipSnapshotBackfill;
    private final CapturingMode capturingMode;
    private final Map<ObjectPath, String> chunkKeyColumns;
    private final Properties dbzProperties;
    private final Configuration dbzConfiguration;
    private final MySqlConnectorConfig dbzMySqlConfig;
    @Nullable
    private final AliyunRdsConfig rdsConfig;

    MySqlSourceConfig(String hostname, int port, String username, String password, List<String> databaseList, List<String> tableList, @Nullable ServerIdRange serverIdRange, StartupOptions startupOptions, int splitSize, int splitMetaGroupSize, int fetchSize, String serverTimeZone, Duration connectTimeout, int connectMaxRetries, int connectionPoolSize, double distributionFactorUpper, double distributionFactorLower, boolean includeSchemaChanges, boolean scanNewlyAddedTableEnabled, boolean closeIdleReaders, Properties dbzProperties, Properties jdbcProperties, Map<ObjectPath, String> chunkKeyColumns, boolean skipSnapshotBackfill, CapturingMode capturingMode, @Nullable AliyunRdsConfig rdsConfig) {
        this.hostname = (String)Preconditions.checkNotNull((Object)hostname);
        this.port = port;
        this.username = (String)Preconditions.checkNotNull((Object)username);
        this.password = password;
        this.databaseList = (List)Preconditions.checkNotNull(databaseList);
        this.tableList = (List)Preconditions.checkNotNull(tableList);
        this.serverIdRange = serverIdRange;
        this.startupOptions = (StartupOptions)Preconditions.checkNotNull((Object)startupOptions);
        this.splitSize = splitSize;
        this.splitMetaGroupSize = splitMetaGroupSize;
        this.fetchSize = fetchSize;
        this.serverTimeZone = (String)Preconditions.checkNotNull((Object)serverTimeZone);
        this.connectTimeout = (Duration)Preconditions.checkNotNull((Object)connectTimeout);
        this.connectMaxRetries = connectMaxRetries;
        this.connectionPoolSize = connectionPoolSize;
        this.distributionFactorUpper = distributionFactorUpper;
        this.distributionFactorLower = distributionFactorLower;
        this.includeSchemaChanges = includeSchemaChanges;
        this.scanNewlyAddedTableEnabled = scanNewlyAddedTableEnabled;
        this.closeIdleReaders = closeIdleReaders;
        this.dbzProperties = (Properties)Preconditions.checkNotNull((Object)dbzProperties);
        this.dbzConfiguration = Configuration.from(dbzProperties);
        this.dbzMySqlConfig = new MySqlConnectorConfig(this.dbzConfiguration);
        this.jdbcProperties = jdbcProperties;
        this.chunkKeyColumns = chunkKeyColumns;
        this.skipSnapshotBackfill = skipSnapshotBackfill;
        this.capturingMode = (CapturingMode)((Object)Preconditions.checkNotNull((Object)((Object)capturingMode), (String)"Capturing mode must be set to %s, %s or %s", (Object[])new Object[]{CapturingMode.HYBRID, CapturingMode.BINLOG_ONLY, CapturingMode.SNAPSHOT_ONLY}));
        this.rdsConfig = rdsConfig;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public List<String> getDatabaseList() {
        return this.databaseList;
    }

    public List<String> getTableList() {
        return this.tableList;
    }

    @Nullable
    public ServerIdRange getServerIdRange() {
        return this.serverIdRange;
    }

    public StartupOptions getStartupOptions() {
        return this.startupOptions;
    }

    public int getSplitSize() {
        return this.splitSize;
    }

    public int getSplitMetaGroupSize() {
        return this.splitMetaGroupSize;
    }

    public double getDistributionFactorUpper() {
        return this.distributionFactorUpper;
    }

    public double getDistributionFactorLower() {
        return this.distributionFactorLower;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectMaxRetries() {
        return this.connectMaxRetries;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public boolean isScanNewlyAddedTableEnabled() {
        return this.scanNewlyAddedTableEnabled;
    }

    public boolean isCloseIdleReaders() {
        return this.closeIdleReaders;
    }

    public Properties getDbzProperties() {
        return this.dbzProperties;
    }

    public Configuration getDbzConfiguration() {
        return this.dbzConfiguration;
    }

    public MySqlConnectorConfig getMySqlConnectorConfig() {
        return this.dbzMySqlConfig;
    }

    public RelationalTableFilters getTableFilters() {
        return this.dbzMySqlConfig.getTableFilters();
    }

    public Properties getJdbcProperties() {
        return this.jdbcProperties;
    }

    public Map<ObjectPath, String> getChunkKeyColumns() {
        return this.chunkKeyColumns;
    }

    public boolean isSkipSnapshotBackfill() {
        return this.skipSnapshotBackfill;
    }

    public CapturingMode getCapturingMode() {
        return this.capturingMode;
    }

    public boolean isReadRdsArchivedBinlogEnabled() {
        return this.rdsConfig != null;
    }

    @Nullable
    public AliyunRdsConfig getRdsConfig() {
        return this.rdsConfig;
    }

    public boolean isTreatTinyintAsBoolean() {
        return Boolean.parseBoolean(this.getJdbcProperties().getProperty("tinyInt1isBit", "true"));
    }
}

