/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source;

import com.ververica.cdc.connectors.mysql.MySqlValidator;
import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.source.MySqlSourceBuilder;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlBinlogSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlHybridSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.MySqlSplitAssigner;
import com.ververica.cdc.connectors.mysql.source.assigners.state.BinlogPendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.HybridPendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.PendingSplitsState;
import com.ververica.cdc.connectors.mysql.source.assigners.state.PendingSplitsStateSerializer;
import com.ververica.cdc.connectors.mysql.source.config.CapturingMode;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfigFactory;
import com.ververica.cdc.connectors.mysql.source.enumerator.MySqlSourceEnumerator;
import com.ververica.cdc.connectors.mysql.source.metrics.MySqlSourceReaderMetrics;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlRecordEmitter;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSourceReader;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSourceReaderContext;
import com.ververica.cdc.connectors.mysql.source.reader.MySqlSplitReader;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplitSerializer;
import com.ververica.cdc.connectors.mysql.source.split.SourceRecords;
import com.ververica.cdc.connectors.mysql.source.utils.hooks.SnapshotPhaseHooks;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import io.debezium.jdbc.JdbcConnection;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.connector.source.Boundedness;
import org.apache.flink.api.connector.source.Source;
import org.apache.flink.api.connector.source.SourceReader;
import org.apache.flink.api.connector.source.SourceReaderContext;
import org.apache.flink.api.connector.source.SplitEnumerator;
import org.apache.flink.api.connector.source.SplitEnumeratorContext;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.SourceReaderOptions;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.synchronization.FutureCompletingBlockingQueue;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;
import org.apache.flink.util.FlinkRuntimeException;

@Internal
public class MySqlSource<T>
implements Source<T, MySqlSplit, PendingSplitsState>,
ResultTypeQueryable<T> {
    private static final long serialVersionUID = 1L;
    private static final String ENUMERATOR_SERVER_NAME = "mysql_source_split_enumerator";
    private final MySqlSourceConfigFactory configFactory;
    private final DebeziumDeserializationSchema<T> deserializationSchema;
    private SnapshotPhaseHooks snapshotHooks = SnapshotPhaseHooks.empty();

    @PublicEvolving
    public static <T> MySqlSourceBuilder<T> builder() {
        return new MySqlSourceBuilder();
    }

    MySqlSource(MySqlSourceConfigFactory configFactory, DebeziumDeserializationSchema<T> deserializationSchema) {
        this.configFactory = configFactory;
        this.deserializationSchema = deserializationSchema;
    }

    public MySqlSourceConfigFactory getConfigFactory() {
        return this.configFactory;
    }

    public Boundedness getBoundedness() {
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(0);
        if (sourceConfig.getCapturingMode() == CapturingMode.SNAPSHOT_ONLY) {
            return Boundedness.BOUNDED;
        }
        return Boundedness.CONTINUOUS_UNBOUNDED;
    }

    public SourceReader<T, MySqlSplit> createReader(SourceReaderContext readerContext) throws Exception {
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(readerContext.getIndexOfSubtask());
        FutureCompletingBlockingQueue elementsQueue = new FutureCompletingBlockingQueue();
        SourceReaderMetricGroup metricGroup = readerContext.metricGroup();
        MySqlSourceReaderMetrics sourceReaderMetrics = new MySqlSourceReaderMetrics(metricGroup);
        MySqlSourceReaderContext mySqlSourceReaderContext = new MySqlSourceReaderContext(readerContext);
        Supplier<SplitReader<SourceRecords, MySqlSplit>> splitReaderSupplier = () -> new MySqlSplitReader(sourceConfig, readerContext.getIndexOfSubtask(), mySqlSourceReaderContext, this.snapshotHooks);
        Configuration config = new Configuration(readerContext.getConfiguration());
        config.setBoolean(SourceReaderOptions.OVERRIDE_METRIC_NUM_RECORDS_IN, true);
        return new MySqlSourceReader<T>((FutureCompletingBlockingQueue<RecordsWithSplitIds<SourceRecords>>)elementsQueue, splitReaderSupplier, new MySqlRecordEmitter<T>(this.deserializationSchema, sourceReaderMetrics, sourceConfig.isIncludeSchemaChanges()), config, mySqlSourceReaderContext, sourceConfig);
    }

    public SplitEnumerator<MySqlSplit, PendingSplitsState> createEnumerator(SplitEnumeratorContext<MySqlSplit> enumContext) {
        MySqlBinlogSplitAssigner splitAssigner;
        MySqlSourceConfig sourceConfig;
        block9: {
            sourceConfig = this.configFactory.createConfig(0, ENUMERATOR_SERVER_NAME);
            MySqlValidator validator = new MySqlValidator(sourceConfig);
            validator.validate();
            if (sourceConfig.getCapturingMode() == CapturingMode.HYBRID || sourceConfig.getCapturingMode() == CapturingMode.SNAPSHOT_ONLY) {
                try (JdbcConnection jdbc = DebeziumUtils.openJdbcConnection(sourceConfig);){
                    boolean isTableIdCaseSensitive = DebeziumUtils.isTableIdCaseSensitive(jdbc);
                    splitAssigner = new MySqlHybridSplitAssigner(sourceConfig, enumContext.currentParallelism(), new ArrayList(), isTableIdCaseSensitive, enumContext);
                    break block9;
                }
                catch (Exception e) {
                    throw new FlinkRuntimeException("Failed to discover captured tables for enumerator", (Throwable)e);
                }
            }
            splitAssigner = new MySqlBinlogSplitAssigner(sourceConfig, enumContext);
        }
        return new MySqlSourceEnumerator(enumContext, sourceConfig, (MySqlSplitAssigner)splitAssigner, this.getBoundedness());
    }

    public SplitEnumerator<MySqlSplit, PendingSplitsState> restoreEnumerator(SplitEnumeratorContext<MySqlSplit> enumContext, PendingSplitsState checkpoint) {
        MySqlHybridSplitAssigner splitAssigner;
        MySqlSourceConfig sourceConfig = this.configFactory.createConfig(0, ENUMERATOR_SERVER_NAME);
        if (checkpoint instanceof HybridPendingSplitsState) {
            splitAssigner = new MySqlHybridSplitAssigner(sourceConfig, enumContext.currentParallelism(), (HybridPendingSplitsState)checkpoint, enumContext);
        } else if (checkpoint instanceof BinlogPendingSplitsState) {
            splitAssigner = new MySqlBinlogSplitAssigner(sourceConfig, (BinlogPendingSplitsState)checkpoint, enumContext);
        } else {
            throw new UnsupportedOperationException("Unsupported restored PendingSplitsState: " + checkpoint);
        }
        return new MySqlSourceEnumerator(enumContext, sourceConfig, (MySqlSplitAssigner)splitAssigner, this.getBoundedness());
    }

    public SimpleVersionedSerializer<MySqlSplit> getSplitSerializer() {
        return MySqlSplitSerializer.INSTANCE;
    }

    public SimpleVersionedSerializer<PendingSplitsState> getEnumeratorCheckpointSerializer() {
        return new PendingSplitsStateSerializer(this.getSplitSerializer());
    }

    public TypeInformation<T> getProducedType() {
        return this.deserializationSchema.getProducedType();
    }

    @VisibleForTesting
    public void setSnapshotHooks(SnapshotPhaseHooks snapshotHooks) {
        this.snapshotHooks = snapshotHooks;
    }
}

