/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.rds.config;

import com.ververica.cdc.connectors.mysql.rds.config.AliyunRdsOptions;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class AliyunRdsConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Configuration configuration;

    public static RdsConfigBuilder builder() {
        return new RdsConfigBuilder();
    }

    public static AliyunRdsConfig fromConfig(ReadableConfig other) {
        AliyunRdsConfig.sanityCheck(other);
        Configuration configuration = new Configuration();
        configuration.set(AliyunRdsOptions.RDS_REGION_ID, (Object)((String)other.get(AliyunRdsOptions.RDS_REGION_ID)));
        configuration.set(AliyunRdsOptions.RDS_ACCESS_KEY_ID, (Object)((String)other.get(AliyunRdsOptions.RDS_ACCESS_KEY_ID)));
        configuration.set(AliyunRdsOptions.RDS_ACCESS_KEY_SECRET, (Object)((String)other.get(AliyunRdsOptions.RDS_ACCESS_KEY_SECRET)));
        configuration.set(AliyunRdsOptions.RDS_DB_INSTANCE_ID, (Object)((String)other.get(AliyunRdsOptions.RDS_DB_INSTANCE_ID)));
        configuration.set(AliyunRdsOptions.RDS_DOWNLOAD_TIMEOUT, (Object)((Duration)other.get(AliyunRdsOptions.RDS_DOWNLOAD_TIMEOUT)));
        if (other.getOptional(AliyunRdsOptions.RDS_BINLOG_DIRECTORIES_PARENT_PATH).isPresent()) {
            configuration.set(AliyunRdsOptions.RDS_BINLOG_DIRECTORIES_PARENT_PATH, (Object)((String)other.get(AliyunRdsOptions.RDS_BINLOG_DIRECTORIES_PARENT_PATH)));
        }
        configuration.set(AliyunRdsOptions.RDS_BINLOG_DIRECTORY_PREFIX, (Object)((String)other.get(AliyunRdsOptions.RDS_BINLOG_DIRECTORY_PREFIX)));
        configuration.set(AliyunRdsOptions.RDS_USE_INTRANET_LINK, (Object)((Boolean)other.get(AliyunRdsOptions.RDS_USE_INTRANET_LINK)));
        return new AliyunRdsConfig(configuration);
    }

    private AliyunRdsConfig(Configuration configuration) {
        this.configuration = configuration;
    }

    public String getRegionId() {
        return (String)this.configuration.get(AliyunRdsOptions.RDS_REGION_ID);
    }

    public String getAccessKeyId() {
        return (String)this.configuration.get(AliyunRdsOptions.RDS_ACCESS_KEY_ID);
    }

    public String getAccessKeySecret() {
        return (String)this.configuration.get(AliyunRdsOptions.RDS_ACCESS_KEY_SECRET);
    }

    public String getDbInstanceId() {
        return (String)this.configuration.get(AliyunRdsOptions.RDS_DB_INSTANCE_ID);
    }

    public Duration getDownloadTimeout() {
        return (Duration)this.configuration.get(AliyunRdsOptions.RDS_DOWNLOAD_TIMEOUT);
    }

    public Path getRandomBinlogDirectoryPath() {
        Optional optionalParent = this.configuration.getOptional(AliyunRdsOptions.RDS_BINLOG_DIRECTORIES_PARENT_PATH);
        String prefix = (String)this.configuration.get(AliyunRdsOptions.RDS_BINLOG_DIRECTORY_PREFIX);
        if (!optionalParent.isPresent()) {
            try {
                return Files.createTempDirectory(prefix, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create temporary directory", e);
            }
        }
        return Paths.get((String)optionalParent.get(), prefix + RandomStringUtils.randomAlphabetic((int)6));
    }

    public boolean isUseIntranetLink() {
        return (Boolean)this.configuration.get(AliyunRdsOptions.RDS_USE_INTRANET_LINK);
    }

    private static void sanityCheck(ReadableConfig configuration) {
        Preconditions.checkState((boolean)configuration.getOptional(AliyunRdsOptions.RDS_ACCESS_KEY_ID).isPresent(), (String)"%s is required if reading archived binlog is enabled.", (Object[])new Object[]{"RDS access key ID"});
        Preconditions.checkState((boolean)configuration.getOptional(AliyunRdsOptions.RDS_ACCESS_KEY_SECRET).isPresent(), (String)"%s is required if reading archived binlog is enabled.", (Object[])new Object[]{"RDS access key secret"});
        Preconditions.checkState((boolean)configuration.getOptional(AliyunRdsOptions.RDS_DB_INSTANCE_ID).isPresent(), (String)"%s is required if reading archived binlog is enabled.", (Object[])new Object[]{"RDS database instance ID"});
        Preconditions.checkState((boolean)configuration.getOptional(AliyunRdsOptions.RDS_REGION_ID).isPresent(), (String)"%s is required if reading archived binlog is enabled.", (Object[])new Object[]{"RDS region ID"});
    }

    public boolean equals(Object o) {
        if (!(o instanceof AliyunRdsConfig)) {
            return false;
        }
        AliyunRdsConfig that = (AliyunRdsConfig)o;
        return Objects.equals(this.configuration, that.configuration);
    }

    public int hashCode() {
        return Objects.hash(this.configuration);
    }

    public static class RdsConfigBuilder {
        private final Configuration configuration = new Configuration();

        public RdsConfigBuilder regionId(String regionId) {
            this.configuration.set(AliyunRdsOptions.RDS_REGION_ID, (Object)regionId);
            return this;
        }

        public RdsConfigBuilder accessKeyId(String accessKeyId) {
            this.configuration.set(AliyunRdsOptions.RDS_ACCESS_KEY_ID, (Object)accessKeyId);
            return this;
        }

        public RdsConfigBuilder accessKeySecret(String accessKeySecret) {
            this.configuration.set(AliyunRdsOptions.RDS_ACCESS_KEY_SECRET, (Object)accessKeySecret);
            return this;
        }

        public RdsConfigBuilder dbInstanceId(String dbInstanceId) {
            this.configuration.set(AliyunRdsOptions.RDS_DB_INSTANCE_ID, (Object)dbInstanceId);
            return this;
        }

        public RdsConfigBuilder downloadTimeout(Duration downloadTimeout) {
            this.configuration.set(AliyunRdsOptions.RDS_DOWNLOAD_TIMEOUT, (Object)downloadTimeout);
            return this;
        }

        public RdsConfigBuilder binlogDirectoriesParentPath(String binlogDirectoriesParentPath) {
            this.configuration.set(AliyunRdsOptions.RDS_BINLOG_DIRECTORIES_PARENT_PATH, (Object)binlogDirectoriesParentPath);
            return this;
        }

        public RdsConfigBuilder binlogDirectoryPrefix(String binlogDirectoryPrefix) {
            this.configuration.set(AliyunRdsOptions.RDS_BINLOG_DIRECTORY_PREFIX, (Object)binlogDirectoryPrefix);
            return this;
        }

        public RdsConfigBuilder useIntranetLink(boolean useIntranetLink) {
            this.configuration.set(AliyunRdsOptions.RDS_USE_INTRANET_LINK, (Object)useIntranetLink);
            return this;
        }

        public AliyunRdsConfig build() {
            AliyunRdsConfig.sanityCheck((ReadableConfig)this.configuration);
            return new AliyunRdsConfig(this.configuration);
        }
    }
}

