/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.util;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampType;

public class StringFormatRowConverter
implements Serializable {
    protected final StringFormatConverter[] toStringConverters;
    protected final LogicalType[] fieldLogicalTypes;
    @Nullable
    protected final transient Function<String, String> stringEscaper;

    public StringFormatRowConverter(LogicalType[] fieldLogicalTypes, @Nullable Function<String, String> stringEscaper) {
        this.fieldLogicalTypes = fieldLogicalTypes;
        this.stringEscaper = stringEscaper;
        this.toStringConverters = new StringFormatConverter[fieldLogicalTypes.length];
        for (int i = 0; i < fieldLogicalTypes.length; ++i) {
            this.toStringConverters[i] = this.createNullableStringConverter(fieldLogicalTypes[i]);
        }
    }

    protected StringFormatConverter createNullableStringConverter(LogicalType type) {
        return this.wrapIntoNullableExternalConverter(this.createStringFormatConverter(type), type);
    }

    protected StringFormatConverter wrapIntoNullableExternalConverter(StringFormatConverter stringConverter, LogicalType type) {
        return (val, index) -> {
            if (val == null || val.isNullAt(index) || LogicalTypeRoot.NULL.equals((Object)type.getTypeRoot())) {
                return null;
            }
            return stringConverter.convertToString(val, index);
        };
    }

    public String[] convertToString(RowData rowData) {
        String[] fields = new String[this.toStringConverters.length];
        for (int index = 0; index < rowData.getArity(); ++index) {
            fields[index] = this.toStringConverters[index].convertToString(rowData, index);
        }
        return fields;
    }

    protected StringFormatConverter createStringFormatConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return (val, index) -> val.getBoolean(index) ? "'true'" : "'false'";
            }
            case TINYINT: {
                return (val, index) -> "" + Byte.valueOf(val.getByte(index)).intValue();
            }
            case SMALLINT: {
                return (val, index) -> String.valueOf(val.getShort(index));
            }
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: {
                return (val, index) -> String.valueOf(val.getInt(index));
            }
            case BIGINT: 
            case INTERVAL_DAY_TIME: {
                return (val, index) -> String.valueOf(val.getLong(index));
            }
            case FLOAT: {
                return (val, index) -> String.valueOf(val.getFloat(index));
            }
            case DOUBLE: {
                return (val, index) -> String.valueOf(val.getDouble(index));
            }
            case DECIMAL: {
                return (val, index) -> {
                    int decimalPrecision = ((DecimalType)type).getPrecision();
                    int decimalScale = ((DecimalType)type).getScale();
                    return String.valueOf(val.getDecimal(index, decimalPrecision, decimalScale).toBigDecimal().doubleValue());
                };
            }
            case CHAR: 
            case VARCHAR: {
                if (this.stringEscaper != null) {
                    return (val, index) -> this.stringEscaper.apply(val.getString(index).toString());
                }
                return (val, index) -> val.getString(index).toString();
            }
            case BINARY: 
            case VARBINARY: {
                return (val, index) -> new String(val.getBinary(index));
            }
            case DATE: {
                return (val, index) -> String.valueOf(Date.valueOf(LocalDate.ofEpochDay(val.getInt(index))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (val, index) -> String.valueOf(Time.valueOf(LocalTime.ofNanoOfDay((long)val.getInt(index) * 1000000L)));
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)type).getPrecision();
                return (val, index) -> String.valueOf(val.getTimestamp(index, timestampPrecision).toTimestamp());
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    static interface StringFormatConverter
    extends Serializable {
        public String convertToString(RowData var1, int var2);
    }
}

