/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class MySqlUtils {
    public static String getSelectSql(String[] selectFields, String[] whereFields, String table) {
        String selectExpressions = Arrays.stream(selectFields).map(name -> "`" + name + "`").collect(Collectors.joining(", "));
        String fieldExpressions = Arrays.stream(whereFields).map(f -> "`" + f + "`=?").collect(Collectors.joining(" AND "));
        return "SELECT " + selectExpressions + " FROM `" + table + "` " + (whereFields.length > 0 ? " WHERE " + fieldExpressions : "");
    }

    public static String getDeleteSql(List<String> whereConditionFields, String table, Set<Integer> nullFieldIndex) {
        Object[] condition = new String[whereConditionFields.size()];
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM `").append(table).append("` WHERE");
        for (int i = 0; i < condition.length; ++i) {
            condition[i] = nullFieldIndex.contains(i) ? " `" + whereConditionFields.get(i) + "` is null" : " `" + whereConditionFields.get(i) + "` = ? ";
        }
        sb.append(StringUtils.join((Object[])condition, (String)" AND "));
        return sb.toString();
    }

    public static String getInsertSql(String[] fieldNames, String table) {
        String insertFields = StringUtils.join((Object[])Arrays.stream(fieldNames).map(name -> "`" + name + "`").toArray(), (String)", ");
        String insertValuePlaceHolders = StringUtils.join((Object[])Arrays.stream(fieldNames).map(name -> "?").toArray(), (String)", ");
        return String.format("INSERT INTO `%s` (%s) values (%s)", table, insertFields, insertValuePlaceHolders);
    }

    public static String getDuplicateUpdateSql(String[] fieldNames, List<String> pkFields, @Nullable List<String> userExcludeUpdateFields, String table) {
        HashSet<String> excludeUpdateFields = new HashSet<String>();
        excludeUpdateFields.addAll(pkFields);
        if (userExcludeUpdateFields != null) {
            excludeUpdateFields.addAll(userExcludeUpdateFields);
        }
        ArrayList<String> insertColumnNames = new ArrayList<String>();
        ArrayList<String> questionMarks = new ArrayList<String>();
        ArrayList<String> updateEqualsExpression = new ArrayList<String>();
        for (String name : fieldNames) {
            insertColumnNames.add("`" + name + "`");
            questionMarks.add("?");
            if (excludeUpdateFields.contains(name)) continue;
            updateEqualsExpression.add("`" + name + "` = values(`" + name + "`)");
        }
        return "INSERT INTO `" + table + "` (" + StringUtils.join((Object[])insertColumnNames.toArray(), (String)",") + ") values (" + StringUtils.join((Object[])questionMarks.toArray(), (String)",") + ") ON DUPLICATE KEY UPDATE " + StringUtils.join((Object[])updateEqualsExpression.toArray(), (String)",");
    }
}

