/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ververica.connectors.jdbc.util;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.apache.flink.connector.jdbc.utils.JdbcTypeUtil;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.utils.TypeConversions;

public class JdbcRowConverter
implements Serializable {
    protected final JdbcDeserializationConverter[] toInternalConverters;
    protected final JdbcSerializationConverter[] toExternalConverters;
    protected final LogicalType[] fieldLogicalTypes;

    public JdbcRowConverter(DataType[] fieldTypes) {
        this((LogicalType[])Arrays.asList(fieldTypes).stream().map(new Function<DataType, Object>(){

            @Override
            public Object apply(DataType dataType) {
                return dataType.getLogicalType();
            }
        }).toArray((IntFunction<A[]>)new IntFunction<LogicalType[]>(){

            @Override
            public LogicalType[] apply(int value) {
                return new LogicalType[value];
            }
        }));
    }

    public JdbcRowConverter(LogicalType[] fieldLogicalTypes) {
        this.fieldLogicalTypes = fieldLogicalTypes;
        this.toInternalConverters = new JdbcDeserializationConverter[fieldLogicalTypes.length];
        this.toExternalConverters = new JdbcSerializationConverter[fieldLogicalTypes.length];
        for (int i = 0; i < fieldLogicalTypes.length; ++i) {
            this.toInternalConverters[i] = this.createNullableInternalConverter(fieldLogicalTypes[i]);
            this.toExternalConverters[i] = this.createNullableExternalConverter(fieldLogicalTypes[i]);
        }
    }

    public LogicalType[] getFieldLogicalTypes() {
        return this.fieldLogicalTypes;
    }

    public RowData toInternal(ResultSet resultSet) throws SQLException {
        GenericRowData genericRowData = new GenericRowData(this.fieldLogicalTypes.length);
        for (int pos = 0; pos < this.fieldLogicalTypes.length; ++pos) {
            Object field = resultSet.getObject(pos + 1);
            genericRowData.setField(pos, this.toInternalConverters[pos].deserialize(field));
        }
        return genericRowData;
    }

    public PreparedStatement toExternal(RowData rowData, PreparedStatement statement) throws SQLException {
        for (int index = 0; index < rowData.getArity(); ++index) {
            this.toExternalConverters[index].serialize(rowData, index, statement, index + 1);
        }
        return statement;
    }

    public PreparedStatement batchToExternal(List<RowData> rowDataList, PreparedStatement statement) throws SQLException {
        int sqlParameterIndex = 1;
        for (RowData rowData : rowDataList) {
            for (int index = 0; index < rowData.getArity(); ++index) {
                this.toExternalConverters[index].serialize(rowData, index, statement, sqlParameterIndex);
                ++sqlParameterIndex;
            }
        }
        return statement;
    }

    protected JdbcDeserializationConverter createNullableInternalConverter(LogicalType type) {
        return this.wrapIntoNullableInternalConverter(this.createInternalConverter(type));
    }

    protected JdbcDeserializationConverter wrapIntoNullableInternalConverter(JdbcDeserializationConverter jdbcDeserializationConverter) {
        return val -> {
            if (val == null) {
                return null;
            }
            return jdbcDeserializationConverter.deserialize(val);
        };
    }

    protected JdbcDeserializationConverter createInternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return val -> null;
            }
            case BOOLEAN: 
            case FLOAT: 
            case DOUBLE: 
            case INTERVAL_YEAR_MONTH: 
            case INTERVAL_DAY_TIME: {
                return val -> val;
            }
            case TINYINT: {
                return val -> {
                    if (val instanceof Boolean) {
                        return (Boolean)val != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
                    }
                    return val instanceof Integer ? Byte.valueOf(((Integer)val).byteValue()) : val;
                };
            }
            case SMALLINT: {
                return val -> {
                    if (val instanceof Boolean) {
                        return (Boolean)val != false ? Short.valueOf((short)1) : Short.valueOf((short)0);
                    }
                    if (val instanceof Byte) {
                        return ((Byte)val).shortValue();
                    }
                    return val instanceof Integer ? Short.valueOf(((Integer)val).shortValue()) : val;
                };
            }
            case INTEGER: {
                return val -> {
                    if (val instanceof Boolean) {
                        return (Boolean)val != false ? Integer.valueOf(1) : Integer.valueOf(0);
                    }
                    if (val instanceof Byte) {
                        return ((Byte)val).intValue();
                    }
                    if (val instanceof Short) {
                        return ((Short)val).intValue();
                    }
                    return val;
                };
            }
            case BIGINT: {
                return val -> {
                    if (val instanceof Boolean) {
                        return (Boolean)val != false ? Long.valueOf(1L) : Long.valueOf(0L);
                    }
                    if (val instanceof Byte) {
                        return ((Byte)val).longValue();
                    }
                    if (val instanceof Short) {
                        return ((Short)val).longValue();
                    }
                    if (val instanceof Integer) {
                        return ((Integer)val).longValue();
                    }
                    return val;
                };
            }
            case DECIMAL: {
                int precision = ((DecimalType)type).getPrecision();
                int scale = ((DecimalType)type).getScale();
                return val -> val instanceof BigInteger ? DecimalData.fromBigDecimal((BigDecimal)new BigDecimal((BigInteger)val, 0), (int)precision, (int)scale) : DecimalData.fromBigDecimal((BigDecimal)((BigDecimal)val), (int)precision, (int)scale);
            }
            case DATE: {
                return val -> (int)((Date)val).toLocalDate().toEpochDay();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return val -> (int)(((Time)val).toLocalTime().toNanoOfDay() / 1000000L);
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return val -> val instanceof LocalDateTime ? TimestampData.fromLocalDateTime((LocalDateTime)((LocalDateTime)val)) : TimestampData.fromTimestamp((Timestamp)((Timestamp)val));
            }
            case CHAR: 
            case VARCHAR: {
                return val -> StringData.fromString((String)((String)val));
            }
            case BINARY: 
            case VARBINARY: {
                return val -> (byte[])val;
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    protected JdbcSerializationConverter createNullableExternalConverter(LogicalType type) {
        return this.wrapIntoNullableExternalConverter(this.createExternalConverter(type), type);
    }

    protected JdbcSerializationConverter wrapIntoNullableExternalConverter(JdbcSerializationConverter jdbcSerializationConverter, LogicalType type) {
        int sqlType = JdbcTypeUtil.typeInformationToSqlType(TypeConversions.fromDataTypeToLegacyInfo((DataType)TypeConversions.fromLogicalToDataType((LogicalType)type)));
        return (val, fieldIndex, statement, sqlIndex) -> {
            if (val == null || val.isNullAt(fieldIndex) || LogicalTypeRoot.NULL.equals((Object)type.getTypeRoot())) {
                statement.setNull(sqlIndex, sqlType);
            } else {
                jdbcSerializationConverter.serialize(val, fieldIndex, statement, sqlIndex);
            }
        };
    }

    protected JdbcSerializationConverter createExternalConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case BOOLEAN: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setBoolean(sqlIndex, val.getBoolean(fieldIndex));
            }
            case TINYINT: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setByte(sqlIndex, val.getByte(fieldIndex));
            }
            case SMALLINT: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setShort(sqlIndex, val.getShort(fieldIndex));
            }
            case INTERVAL_YEAR_MONTH: 
            case INTEGER: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setInt(sqlIndex, val.getInt(fieldIndex));
            }
            case INTERVAL_DAY_TIME: 
            case BIGINT: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setLong(sqlIndex, val.getLong(fieldIndex));
            }
            case FLOAT: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setFloat(sqlIndex, val.getFloat(fieldIndex));
            }
            case DOUBLE: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setDouble(sqlIndex, val.getDouble(fieldIndex));
            }
            case CHAR: 
            case VARCHAR: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setString(sqlIndex, val.getString(fieldIndex).toString());
            }
            case BINARY: 
            case VARBINARY: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setBytes(sqlIndex, val.getBinary(fieldIndex));
            }
            case DATE: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setDate(sqlIndex, Date.valueOf(LocalDate.ofEpochDay(val.getInt(fieldIndex))));
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return (val, fieldIndex, statement, sqlIndex) -> statement.setTime(sqlIndex, Time.valueOf(LocalTime.ofNanoOfDay((long)val.getInt(fieldIndex) * 1000000L)));
            }
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int timestampPrecision = ((TimestampType)type).getPrecision();
                return this.createExternalConverterForTimestamp(timestampPrecision);
            }
            case DECIMAL: {
                int decimalPrecision = ((DecimalType)type).getPrecision();
                int decimalScale = ((DecimalType)type).getScale();
                return (val, fieldIndex, statement, sqlIndex) -> statement.setBigDecimal(sqlIndex, val.getDecimal(fieldIndex, decimalPrecision, decimalScale).toBigDecimal());
            }
        }
        throw new UnsupportedOperationException("Unsupported type:" + type);
    }

    protected JdbcSerializationConverter createExternalConverterForTimestamp(int timestampPrecision) {
        return (val, fieldIndex, statement, sqlIndex) -> statement.setTimestamp(sqlIndex, val.getTimestamp(fieldIndex, timestampPrecision).toTimestamp());
    }

    @FunctionalInterface
    protected static interface JdbcSerializationConverter
    extends Serializable {
        public void serialize(RowData var1, int var2, PreparedStatement var3, int var4) throws SQLException;
    }

    @FunctionalInterface
    static interface JdbcDeserializationConverter
    extends Serializable {
        public Object deserialize(Object var1) throws SQLException;
    }
}

